/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duraboss.rest.report;

import java.io.InputStream;
import java.util.Date;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.common.util.CalendarUtil;
import org.duracloud.error.ContentStoreException;
import org.duracloud.reportdata.storage.StorageReportInfo;
import org.duracloud.reportdata.storage.StorageReportList;
import org.duracloud.reportdata.storage.serialize.StorageReportInfoSerializer;
import org.duracloud.reportdata.storage.serialize.StorageReportListSerializer;
import org.duracloud.reporter.error.InvalidScheduleException;
import org.duracloud.reporter.storage.StorageReportBuilder;
import org.duracloud.reporter.storage.StorageReportHandler;
import org.duracloud.reporter.storage.StorageReportScheduler;

public class StorageReportResource {
    private String reportPrefix = null;
    private String errorLogName = null;
    private ContentStoreManager storeMgr = null;
    private StorageReportBuilder reportBuilder;
    private StorageReportHandler reportHandler;
    private StorageReportScheduler reportScheduler;

    public StorageReportResource(String reportPrefix, String errorLogName) {
        this.reportPrefix = reportPrefix;
        this.errorLogName = errorLogName;
    }

    public void initialize(ContentStoreManager storeMgr, String reportSpaceId) {
        this.storeMgr = storeMgr;
        this.reportHandler = new StorageReportHandler(storeMgr, reportSpaceId, this.reportPrefix, this.errorLogName);
        this.reportBuilder = new StorageReportBuilder(storeMgr, this.reportHandler);
        if (null != this.reportScheduler) {
            this.reportScheduler.cancelStorageReportSchedule();
            this.reportScheduler.cancelStorageReport();
        }
        this.reportScheduler = new StorageReportScheduler(this.reportBuilder);
        this.scheduleStorageReport(this.getDefaultScheduleStartDate().getTime(), 604800000L);
        this.startStorageReport();
    }

    protected Date getDefaultScheduleStartDate() {
        return new CalendarUtil().getDateAtOneAmNext(CalendarUtil.DAY_OF_WEEK.SAT);
    }

    protected void initialize(ContentStoreManager storeMgr, StorageReportHandler reportHander, StorageReportBuilder reportBuilder, StorageReportScheduler reportScheduler) {
        this.storeMgr = storeMgr;
        this.reportHandler = reportHander;
        this.reportBuilder = reportBuilder;
        this.reportScheduler = reportScheduler;
    }

    public boolean isInitialized() {
        try {
            this.checkInitialized();
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public InputStream getLatestStorageReport() throws ContentStoreException {
        this.checkInitialized();
        return this.reportHandler.getLatestStorageReportStream();
    }

    public InputStream getStorageReport(String reportId) throws ContentStoreException {
        this.checkInitialized();
        return this.reportHandler.getStorageReportStream(reportId);
    }

    public String getStorageReportList() throws ContentStoreException {
        this.checkInitialized();
        StorageReportList reportList = this.reportHandler.getStorageReportList();
        StorageReportListSerializer serializer = new StorageReportListSerializer();
        return serializer.serialize((Object)reportList);
    }

    public String getStorageReportInfo() {
        this.checkInitialized();
        StorageReportInfo reportInfo = new StorageReportInfo();
        StorageReportBuilder.Status status = this.reportBuilder.getStatus();
        reportInfo.setStatus(status.name());
        if (status.equals((Object)StorageReportBuilder.Status.ERROR)) {
            reportInfo.setError(this.reportBuilder.getError());
        }
        long startTime = this.reportBuilder.getStartTime();
        long stopTime = this.reportBuilder.getStopTime();
        long elapsedTime = this.reportBuilder.getElapsedTime();
        long count = this.reportBuilder.getCurrentCount();
        reportInfo.setStartTime(startTime);
        if (stopTime < startTime) {
            if (elapsedTime > 0L) {
                long estCompletionTime = startTime + elapsedTime;
                reportInfo.setEstimatedCompletionTime(estCompletionTime);
            }
            reportInfo.setCurrentCount(count);
        } else {
            reportInfo.setCompletionTime(stopTime);
            reportInfo.setFinalCount(count);
        }
        Date nextScheduledDate = this.reportScheduler.getNextScheduledStartDate();
        if (null != nextScheduledDate) {
            reportInfo.setNextScheduledStartTime(nextScheduledDate.getTime());
        }
        StorageReportInfoSerializer serializer = new StorageReportInfoSerializer();
        return serializer.serialize((Object)reportInfo);
    }

    public String startStorageReport() {
        this.checkInitialized();
        return this.reportScheduler.startStorageReport();
    }

    public String scheduleStorageReport(long startTime, long frequency) throws InvalidScheduleException {
        this.checkInitialized();
        if (new Date(startTime).before(new Date())) {
            throw new InvalidScheduleException("Cannot set report schedule which starts in the past");
        }
        if (frequency < 600000L) {
            throw new InvalidScheduleException("Minimum frequency for report schedule is 10 minutes.");
        }
        return this.reportScheduler.scheduleStorageReport(new Date(startTime), frequency);
    }

    public String cancelStorageReportSchedule() {
        this.checkInitialized();
        return this.reportScheduler.cancelStorageReportSchedule();
    }

    public String cancelStorageReport() {
        return this.reportScheduler.cancelStorageReport();
    }

    public void dispose() {
        this.cancelStorageReport();
    }

    private void checkInitialized() {
        if (null == this.storeMgr) {
            throw new RuntimeException("DuraBoss must be initialized.");
        }
    }
}

