/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.manifest.impl;

import org.duracloud.common.constant.ManifestFormat;
import org.duracloud.manifest.ManifestFormatter;
import org.duracloud.manifest.impl.BagitManifestFormatter;
import org.duracloud.manifest.impl.ManifestFormatterBase;
import org.duracloud.manifest.impl.TsvManifestFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestFormatterFactory {
    private Logger log = LoggerFactory.getLogger(ManifestFormatterFactory.class);

    public ManifestFormatter create(ManifestFormat format) {
        ManifestFormatterBase formatter;
        switch (format) {
            case BAGIT: {
                formatter = new BagitManifestFormatter();
                break;
            }
            case TSV: {
                formatter = new TsvManifestFormatter();
                break;
            }
            default: {
                String err = "Unexpected format: " + format.name();
                this.log.error(err);
                throw new RuntimeException(err);
            }
        }
        return formatter;
    }
}

