/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.manifest.impl;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.duracloud.manifest.impl.ManifestFormatterBase;
import org.duracloud.mill.db.model.ManifestItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsvManifestFormatter
extends ManifestFormatterBase {
    private final Logger log = LoggerFactory.getLogger(TsvManifestFormatter.class);
    private static Pattern LINE_PATTERN = Pattern.compile("(.+)\t(.+)\t(.+)");
    private static final String HEADER = "space-id\tcontent-id\tMD5";

    @Override
    protected Logger log() {
        return this.log;
    }

    @Override
    public String getHeader() {
        return HEADER;
    }

    @Override
    protected String formatLine(String contentMd5, String spaceId, String contentId) {
        StringBuilder line = new StringBuilder();
        line.append(spaceId);
        line.append('\t');
        line.append(contentId);
        line.append('\t');
        line.append(contentMd5);
        return line.toString();
    }

    @Override
    public ManifestItem parseLine(String line) throws ParseException {
        Matcher matcher = LINE_PATTERN.matcher(line);
        if (!matcher.find()) {
            throw new ParseException("Line doesn't match tsv format: unable to parse line: ->" + line + "<-", 0);
        }
        ManifestItem item = new ManifestItem();
        item.setSpaceId(matcher.group(1));
        item.setContentId(matcher.group(2));
        item.setContentChecksum(matcher.group(3));
        return item;
    }
}

