/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.annotations;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassFinder {
    private static final char PKG_SEPARATOR = '.';
    private static final char DIR_SEPARATOR = '/';
    private static final String CLASS_FILE_SUFFIX = ".class";
    private static final String BAD_PACKAGE_ERROR = "Unable to get resources from path '%s'. Are you sure the package '%s' exists?";

    public static List<Class<?>> find(String scannedPackage) {
        return ClassFinder.findAnnotated(scannedPackage, null);
    }

    public static List<Class<?>> findAnnotated(String scannedPackage, Class annotation) {
        ArrayList classes;
        block4: {
            String scannedPath = scannedPackage.replace('.', '/');
            URL scannedUrl = Thread.currentThread().getContextClassLoader().getResource(scannedPath);
            if (scannedUrl == null) {
                throw new IllegalArgumentException(String.format(BAD_PACKAGE_ERROR, scannedPath, scannedPackage));
            }
            File scannedDir = new File(scannedUrl.getFile());
            classes = new ArrayList();
            try {
                File[] files;
                for (File file : files = scannedDir.listFiles()) {
                    if (file == null) continue;
                    classes.addAll(ClassFinder.find(file, scannedPackage, annotation));
                }
            }
            catch (NullPointerException e) {
                if (!classes.isEmpty()) break block4;
                String pathToJar = null;
                pathToJar = scannedUrl.getPath().contains("file:") ? scannedUrl.getPath().substring(5, scannedUrl.getPath().indexOf(".jar") + 4) : scannedUrl.getPath().substring(0, scannedUrl.getPath().indexOf(".jar") + 4);
                classes.addAll(ClassFinder.findjar(pathToJar, scannedPath, annotation));
            }
        }
        return classes;
    }

    private static List<Class<?>> findjar(String pathToJar, String scannedPath, Class annotation) {
        ArrayList classes = new ArrayList();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(pathToJar);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                int endIndex;
                String resource;
                String path;
                JarEntry je = e.nextElement();
                if (je.isDirectory() || !je.getName().endsWith(CLASS_FILE_SUFFIX) || !(path = (resource = je.getName()).substring(0, endIndex = resource.length() - CLASS_FILE_SUFFIX.length())).contains(scannedPath)) continue;
                String className = path.replace('/', '.');
                try {
                    Class<?> aClass = Class.forName(className);
                    if (annotation != null) {
                        if (!Class.forName(className).isAnnotationPresent(annotation)) continue;
                        classes.add(aClass);
                        continue;
                    }
                    classes.add(aClass);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return classes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<Class<?>> find(File file, String scannedPackage, Class annotation) {
        ArrayList classes = new ArrayList();
        String resource = scannedPackage + '.' + file.getName();
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                classes.addAll(ClassFinder.find(child, resource, annotation));
            }
            return classes;
        } else {
            if (!resource.endsWith(CLASS_FILE_SUFFIX)) return classes;
            int endIndex = resource.length() - CLASS_FILE_SUFFIX.length();
            String className = resource.substring(0, endIndex);
            try {
                Class<?> aClass = Class.forName(className);
                if (annotation != null) {
                    if (!Class.forName(className).isAnnotationPresent(annotation)) return classes;
                    classes.add(aClass);
                    return classes;
                }
                classes.add(aClass);
                return classes;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return classes;
    }
}

