/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dvare.binding.function.FunctionBinding;
import org.dvare.expression.operation.OperationExpression;

public enum ConfigurationRegistry {
    INSTANCE;

    private final Map<String, FunctionBinding> functions = new HashMap<String, FunctionBinding>();
    private final Map<String, Class> operations = new HashMap<String, Class>();

    public List<String> tokens() {
        ArrayList<String> tokens = new ArrayList<String>();
        for (String key : this.operations.keySet()) {
            tokens.add(key);
        }
        return tokens;
    }

    public void registerOperation(Class op, List<String> symbols) {
        for (String symbol : symbols) {
            if (this.operations.containsKey(symbol)) continue;
            this.operations.put(symbol, op);
        }
    }

    public void registerFunction(FunctionBinding binding) {
        this.functions.put(binding.getMethodName(), binding);
    }

    public OperationExpression getOperation(String symbol) {
        Class aClass = this.operations.get(symbol);
        OperationExpression operationExpression = null;
        if (aClass != null) {
            try {
                operationExpression = (OperationExpression)aClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return operationExpression;
    }

    public FunctionBinding getFunction(String name) {
        FunctionBinding functionBinding = this.functions.get(name);
        if (functionBinding != null) {
            return functionBinding.copy();
        }
        return null;
    }

    public List<String> getFunctionNames() {
        ArrayList<String> functionNames = new ArrayList<String>();
        for (String key : this.functions.keySet()) {
            functionNames.add(key);
        }
        return functionNames;
    }
}

