/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.config;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.dvare.binding.function.FunctionBinding;
import org.dvare.config.ConfigurationRegistry;
import org.dvare.config.RuleConfigurationProvider;
import org.dvare.evaluator.RuleEvaluator;
import org.dvare.parser.ExpressionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleConfiguration {
    private static Logger logger = LoggerFactory.getLogger(RuleConfiguration.class);
    private ConfigurationRegistry configurationRegistry = ConfigurationRegistry.INSTANCE;
    private ExpressionParser expressionParser;

    public RuleConfiguration() {
        this(null);
    }

    public RuleConfiguration(String[] functionBasePackages) {
        this(functionBasePackages, false);
    }

    public RuleConfiguration(String[] functionBasePackages, boolean silentMode) {
        if (silentMode) {
            try {
                Class.forName("org.apache.log4j.LogManager");
                ArrayList<org.apache.log4j.Logger> loggers = Collections.list(LogManager.getCurrentLoggers());
                loggers.add(LogManager.getRootLogger());
                for (org.apache.log4j.Logger logger : loggers) {
                    if (!logger.getName().startsWith("org.dvare") && !logger.getName().equals("root")) continue;
                    logger.setLevel(Level.OFF);
                }
            }
            catch (ClassNotFoundException e) {
                logger.error(e.getMessage());
            }
        }
        new RuleConfigurationProvider(functionBasePackages).init();
    }

    public RuleEvaluator getEvaluator() {
        return new RuleEvaluator();
    }

    public ExpressionParser getParser() {
        if (this.expressionParser == null) {
            this.expressionParser = new ExpressionParser();
        }
        return this.expressionParser;
    }

    public void registerFunction(FunctionBinding binding) {
        this.configurationRegistry.registerFunction(binding);
    }

    public ConfigurationRegistry getConfigurationRegistry() {
        return this.configurationRegistry;
    }
}

