/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.config;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.dvare.annotations.ClassFinder;
import org.dvare.annotations.FunctionMethod;
import org.dvare.annotations.FunctionService;
import org.dvare.annotations.Operation;
import org.dvare.binding.function.FunctionBinding;
import org.dvare.config.ConfigurationRegistry;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.util.DataTypeMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleConfigurationProvider {
    private static Logger logger = LoggerFactory.getLogger(RuleConfigurationProvider.class);
    private final String baseOperationPackage = "org.dvare.expression.operation";
    public ConfigurationRegistry configurationRegistry = ConfigurationRegistry.INSTANCE;
    private String[] functionBasePackages;

    public RuleConfigurationProvider(String[] functionBasePackages) {
        this.functionBasePackages = functionBasePackages;
    }

    public void init() {
        this.operationInit();
        this.functionInit();
    }

    private void functionInit() {
        if (this.functionBasePackages != null) {
            for (String functionPackage : this.functionBasePackages) {
                List<Class<?>> classes = ClassFinder.findAnnotated(functionPackage, FunctionService.class);
                for (Class<?> _class : classes) {
                    for (Method method : _class.getMethods()) {
                        if (!method.isAnnotationPresent(FunctionMethod.class)) continue;
                        String functionName = method.getName();
                        FunctionMethod functionMethod = method.getAnnotation(FunctionMethod.class);
                        DataType returnType = functionMethod.returnType();
                        DataType[] parameters = functionMethod.parameters();
                        Class<? extends DataTypeExpression> returnTypeExpression = DataTypeMapping.getDataTypeClass(returnType);
                        FunctionBinding functionBinding = new FunctionBinding(functionName, _class, returnTypeExpression);
                        functionBinding.setParameters(Arrays.asList(parameters));
                        this.configurationRegistry.registerFunction(functionBinding);
                    }
                }
            }
        }
    }

    private void operationInit() {
        List<Class<?>> classes = ClassFinder.findAnnotated("org.dvare.expression.operation", Operation.class);
        for (Class<?> _class : classes) {
            Operation annotation = _class.getAnnotation(Operation.class);
            if (annotation == null || !(annotation instanceof Operation)) continue;
            this.configurationRegistry.registerOperation(_class, annotation.type().getSymbols());
        }
    }
}

