/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.evaluator;

import java.util.HashMap;
import java.util.List;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.rule.RuleBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.literal.LiteralExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEvaluator {
    static Logger logger = LoggerFactory.getLogger(RuleEvaluator.class);

    public Object evaluate(RuleBinding rule, Object object) throws InterpretException {
        return this.evaluate(rule, object, null);
    }

    public Object evaluate(RuleBinding rule, Object self, Object data) throws InterpretException {
        InstancesBinding instancesBinding = new InstancesBinding(new HashMap<String, Object>());
        instancesBinding.addInstance("self", self);
        instancesBinding.addInstance("data", data);
        return this.evaluate(rule, instancesBinding);
    }

    public Object evaluate(RuleBinding rule, InstancesBinding instancesBinding) throws InterpretException {
        return this.evaluate(rule, null, instancesBinding);
    }

    public Object evaluate(RuleBinding rule, ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        Object result = null;
        Object ruleRawResult = rule.getExpression().interpret(expressionBinding, instancesBinding);
        if (ruleRawResult instanceof LiteralExpression) {
            LiteralExpression literalExpression = (LiteralExpression)ruleRawResult;
            if (literalExpression.getValue() != null) {
                result = literalExpression.getValue();
            }
        } else {
            result = ruleRawResult;
        }
        return result;
    }

    public InstancesBinding aggregate(List<RuleBinding> rules, InstancesBinding instancesBinding) throws InterpretException {
        return this.aggregate(rules, null, instancesBinding);
    }

    public InstancesBinding aggregate(List<RuleBinding> rules, ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        for (RuleBinding rule : rules) {
            rule.getExpression().interpret(expressionBinding, instancesBinding);
        }
        return instancesBinding;
    }

    public Object aggregate(RuleBinding rule, InstancesBinding instancesBinding) throws InterpretException {
        return this.aggregate(rule, null, instancesBinding);
    }

    public Object aggregate(RuleBinding rule, ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        rule.getExpression().interpret(expressionBinding, instancesBinding);
        return instancesBinding;
    }

    public Object aggregate(List<RuleBinding> rules, Object aggregate, Object dataset) throws InterpretException {
        InstancesBinding instancesBinding = new InstancesBinding(new HashMap<String, Object>());
        instancesBinding.addInstance("self", aggregate);
        instancesBinding.addInstance("data", dataset);
        for (RuleBinding rule : rules) {
            rule.getExpression().interpret(null, instancesBinding);
        }
        return instancesBinding.getInstance("self");
    }

    public Object aggregate(RuleBinding rule, Object aggregate, Object dataset) throws InterpretException {
        InstancesBinding instancesBinding = new InstancesBinding(new HashMap<String, Object>());
        instancesBinding.addInstance("self", aggregate);
        instancesBinding.addInstance("data", dataset);
        rule.getExpression().interpret(null, instancesBinding);
        return instancesBinding.getInstance("self");
    }
}

