/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.datatype;

import java.util.ArrayList;
import java.util.List;
import org.dvare.annotations.OperationMapping;
import org.dvare.annotations.Type;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.operation.validation.Equals;
import org.dvare.expression.operation.validation.In;
import org.dvare.expression.operation.validation.NotEquals;
import org.dvare.expression.operation.validation.NotIn;

@Type(dataType=DataType.BooleanType)
public class BooleanType
extends DataTypeExpression {
    public BooleanType() {
        super(DataType.BooleanType);
    }

    @OperationMapping(operations={Equals.class})
    public boolean equal(LiteralExpression left, LiteralExpression right) {
        Boolean rightValue;
        Boolean leftValue = (Boolean)left.getValue();
        return leftValue == (rightValue = (Boolean)right.getValue());
    }

    @OperationMapping(operations={NotEquals.class})
    public boolean notEqual(LiteralExpression left, LiteralExpression right) {
        Boolean rightValue;
        Boolean leftValue = (Boolean)left.getValue();
        return leftValue != (rightValue = (Boolean)right.getValue());
    }

    @OperationMapping(operations={In.class})
    public boolean in(LiteralExpression left, LiteralExpression right) {
        Boolean leftValue = (Boolean)left.getValue();
        List<Boolean> rightValues = this.buildIntegerBoolean((List)right.getValue());
        return rightValues.contains(leftValue);
    }

    @OperationMapping(operations={NotIn.class})
    public boolean notIn(LiteralExpression left, LiteralExpression right) {
        Boolean leftValue = (Boolean)left.getValue();
        List<Boolean> rightValues = this.buildIntegerBoolean((List)right.getValue());
        return !rightValues.contains(leftValue);
    }

    private List<Boolean> buildIntegerBoolean(List<Object> tempValues) {
        ArrayList<Boolean> values = new ArrayList<Boolean>();
        for (Object tempValue : tempValues) {
            if (tempValue instanceof Boolean) {
                values.add((Boolean)tempValue);
                continue;
            }
            try {
                Boolean value = Boolean.parseBoolean(tempValue.toString());
                values.add(value);
            }
            catch (NullPointerException e) {
                values.add(null);
            }
        }
        return values;
    }
}

