/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.datatype;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.dvare.annotations.OperationMapping;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.util.DataTypeMapping;

public abstract class DataTypeExpression
extends Expression {
    protected DataType dataType;

    public DataTypeExpression(DataType dataType) {
        this.dataType = dataType;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public LiteralExpression evaluate(OperationExpression operationExpression, LiteralExpression left, LiteralExpression right) throws InterpretException {
        try {
            Method method;
            Object result;
            String methodName = this.getMethodName(operationExpression.getClass());
            if (methodName != null && (result = (method = this.getClass().getMethod(methodName, LiteralExpression.class, LiteralExpression.class)).invoke((Object)this, left, right)) != null) {
                DataType type = DataTypeMapping.getTypeMapping(result.getClass());
                if (type == null && (type = LiteralType.computeDataType(result.toString())) == null) {
                    type = this.getDataType();
                }
                return LiteralType.getLiteralExpression(result, type);
            }
            return new NullLiteral();
        }
        catch (Exception m) {
            throw new InterpretException(m);
        }
    }

    private String getMethodName(Class operation) {
        for (Method method : this.getClass().getMethods()) {
            OperationMapping operationMapping;
            OperationMapping annotation = method.getAnnotation(OperationMapping.class);
            if (annotation == null || !Arrays.asList((operationMapping = annotation).operations()).contains(operation)) continue;
            return method.getName();
        }
        return null;
    }
}

