/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.datatype;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dvare.annotations.OperationMapping;
import org.dvare.annotations.Type;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.operation.validation.Between;
import org.dvare.expression.operation.validation.Equals;
import org.dvare.expression.operation.validation.GreaterEqual;
import org.dvare.expression.operation.validation.GreaterThen;
import org.dvare.expression.operation.validation.In;
import org.dvare.expression.operation.validation.LessEqual;
import org.dvare.expression.operation.validation.LessThen;
import org.dvare.expression.operation.validation.NotEquals;
import org.dvare.expression.operation.validation.NotIn;

@Type(dataType=DataType.DateTimeType)
public class DateTimeType
extends DataTypeExpression {
    public DateTimeType() {
        super(DataType.DateTimeType);
    }

    @OperationMapping(operations={Equals.class})
    public boolean equal(LiteralExpression left, LiteralExpression right) {
        LocalDateTime rightValue;
        LocalDateTime leftValue = (LocalDateTime)left.getValue();
        return leftValue.compareTo(rightValue = (LocalDateTime)right.getValue()) == 0;
    }

    @OperationMapping(operations={NotEquals.class})
    public boolean notEqual(LiteralExpression left, LiteralExpression right) {
        LocalDateTime rightValue;
        LocalDateTime leftValue = (LocalDateTime)left.getValue();
        return leftValue.compareTo(rightValue = (LocalDateTime)right.getValue()) != 0;
    }

    @OperationMapping(operations={LessThen.class})
    public boolean less(LiteralExpression left, LiteralExpression right) {
        LocalDateTime rightValue;
        LocalDateTime leftValue = (LocalDateTime)left.getValue();
        return leftValue.compareTo(rightValue = (LocalDateTime)right.getValue()) < 0;
    }

    @OperationMapping(operations={LessEqual.class})
    public boolean lessEqual(LiteralExpression left, LiteralExpression right) {
        LocalDateTime rightValue;
        LocalDateTime leftValue = (LocalDateTime)left.getValue();
        return leftValue.compareTo(rightValue = (LocalDateTime)right.getValue()) <= 0;
    }

    @OperationMapping(operations={GreaterThen.class})
    public boolean greater(LiteralExpression left, LiteralExpression right) {
        LocalDateTime rightValue;
        LocalDateTime leftValue = (LocalDateTime)left.getValue();
        return leftValue.compareTo(rightValue = (LocalDateTime)right.getValue()) > 0;
    }

    @OperationMapping(operations={GreaterEqual.class})
    public boolean greaterEqual(LiteralExpression left, LiteralExpression right) {
        LocalDateTime rightValue;
        LocalDateTime leftValue = (LocalDateTime)left.getValue();
        return leftValue.compareTo(rightValue = (LocalDateTime)right.getValue()) >= 0;
    }

    @OperationMapping(operations={In.class})
    public boolean in(LiteralExpression left, LiteralExpression right) {
        LocalDateTime leftValue = (LocalDateTime)left.getValue();
        List<LocalDateTime> rightValues = this.buildDateList((List)right.getValue());
        return rightValues.contains(leftValue);
    }

    @OperationMapping(operations={NotIn.class})
    public boolean notIn(LiteralExpression left, LiteralExpression right) {
        LocalDateTime leftValue = (LocalDateTime)left.getValue();
        List<LocalDateTime> rightValues = this.buildDateList((List)right.getValue());
        return !rightValues.contains(leftValue);
    }

    @OperationMapping(operations={Between.class})
    public boolean between(LiteralExpression left, LiteralExpression right) {
        LocalDateTime leftValue = (LocalDateTime)left.getValue();
        List<LocalDateTime> values = this.buildDateList((List)right.getValue());
        LocalDateTime lower = values.get(0);
        LocalDateTime upper = values.get(1);
        return lower.compareTo(leftValue) <= 0 && leftValue.compareTo(upper) <= 0;
    }

    private List<LocalDateTime> buildDateList(List<?> objects) {
        ArrayList<LocalDateTime> localDateTimeList = new ArrayList<LocalDateTime>();
        for (Object object : objects) {
            LocalDateTime localDateTime;
            if (object instanceof LocalDateTime) {
                localDateTimeList.add((LocalDateTime)object);
                continue;
            }
            if (object instanceof Date) {
                Date date = (Date)object;
                localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                localDateTimeList.add(localDateTime);
                continue;
            }
            try {
                LocalDateTime localDateTime2 = LocalDateTime.parse(object.toString(), LiteralType.dateTimeFormat);
                localDateTimeList.add(localDateTime2);
            }
            catch (Exception e) {
                try {
                    localDateTime = LocalDateTime.parse(object.toString(), LiteralType.dateFormat);
                    localDateTimeList.add(localDateTime);
                }
                catch (Exception e2) {
                    try {
                        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("E MMM dd hh:mm:ss Z yyyy");
                        LocalDateTime localDateTime3 = LocalDateTime.parse(object.toString(), dateTimeFormatter);
                        localDateTimeList.add(localDateTime3);
                    }
                    catch (Exception e3) {
                        localDateTimeList.add(null);
                    }
                }
            }
        }
        return localDateTimeList;
    }
}

