/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.datatype;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dvare.annotations.OperationMapping;
import org.dvare.annotations.Type;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.operation.arithmetic.Subtract;
import org.dvare.expression.operation.validation.Between;
import org.dvare.expression.operation.validation.Equals;
import org.dvare.expression.operation.validation.GreaterEqual;
import org.dvare.expression.operation.validation.GreaterThen;
import org.dvare.expression.operation.validation.In;
import org.dvare.expression.operation.validation.LessEqual;
import org.dvare.expression.operation.validation.LessThen;
import org.dvare.expression.operation.validation.NotEquals;
import org.dvare.expression.operation.validation.NotIn;

@Type(dataType=DataType.DateType)
public class DateType
extends DataTypeExpression {
    public DateType() {
        super(DataType.DateType);
    }

    @OperationMapping(operations={Equals.class})
    public boolean equal(LiteralExpression left, LiteralExpression right) {
        LocalDate leftValue = this.toLocalDate(left.getValue());
        LocalDate rightValue = this.toLocalDate(right.getValue());
        return leftValue != null && rightValue != null && leftValue.compareTo(rightValue) == 0;
    }

    @OperationMapping(operations={NotEquals.class})
    public boolean notEqual(LiteralExpression left, LiteralExpression right) {
        LocalDate leftValue = this.toLocalDate(left.getValue());
        LocalDate rightValue = this.toLocalDate(right.getValue());
        return leftValue != null && rightValue != null && leftValue.compareTo(rightValue) != 0;
    }

    @OperationMapping(operations={LessThen.class})
    public boolean less(LiteralExpression left, LiteralExpression right) {
        LocalDate leftValue = this.toLocalDate(left.getValue());
        LocalDate rightValue = this.toLocalDate(right.getValue());
        return leftValue != null && rightValue != null && leftValue.compareTo(rightValue) < 0;
    }

    @OperationMapping(operations={LessEqual.class})
    public boolean lessEqual(LiteralExpression left, LiteralExpression right) {
        LocalDate leftValue = this.toLocalDate(left.getValue());
        LocalDate rightValue = this.toLocalDate(right.getValue());
        return leftValue != null && rightValue != null && leftValue.compareTo(rightValue) <= 0;
    }

    @OperationMapping(operations={GreaterThen.class})
    public boolean greater(LiteralExpression left, LiteralExpression right) {
        LocalDate leftValue = this.toLocalDate(left.getValue());
        LocalDate rightValue = this.toLocalDate(right.getValue());
        return leftValue != null && rightValue != null && leftValue.compareTo(rightValue) > 0;
    }

    @OperationMapping(operations={GreaterEqual.class})
    public boolean greaterEqual(LiteralExpression left, LiteralExpression right) {
        LocalDate leftValue = this.toLocalDate(left.getValue());
        LocalDate rightValue = this.toLocalDate(right.getValue());
        return leftValue != null && rightValue != null && leftValue.compareTo(rightValue) >= 0;
    }

    @OperationMapping(operations={In.class})
    public boolean in(LiteralExpression left, LiteralExpression right) {
        LocalDate leftValue = this.toLocalDate(left.getValue());
        ArrayList<LocalDate> rightValues = new ArrayList<LocalDate>();
        for (LocalDate rightValue : this.buildLocalDateList((List)right.getValue())) {
            rightValues.add(rightValue);
        }
        return rightValues.contains(leftValue);
    }

    @OperationMapping(operations={NotIn.class})
    public boolean notIn(LiteralExpression left, LiteralExpression right) {
        LocalDate leftValue = this.toLocalDate(left.getValue());
        ArrayList<LocalDate> rightValues = new ArrayList<LocalDate>();
        for (LocalDate rightValue : this.buildLocalDateList((List)right.getValue())) {
            rightValues.add(rightValue);
        }
        return !rightValues.contains(leftValue);
    }

    @OperationMapping(operations={Between.class})
    public boolean between(LiteralExpression left, LiteralExpression right) {
        LocalDate leftValue = this.toLocalDate(left.getValue());
        List<LocalDate> values = this.buildLocalDateList((List)right.getValue());
        LocalDate lower = values.get(0);
        LocalDate upper = values.get(1);
        return lower.compareTo(leftValue) <= 0 && leftValue.compareTo(upper) <= 0;
    }

    private LocalDate toLocalDate(Object value) {
        if (value instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)value;
            return localDateTime.toLocalDate();
        }
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        return null;
    }

    @OperationMapping(operations={Subtract.class})
    public LocalDate sub(LiteralExpression left, LiteralExpression right) {
        int month;
        int year;
        LocalDate leftValue = (LocalDate)left.getValue();
        LocalDate rightValue = (LocalDate)right.getValue();
        Period period = Period.between(rightValue, leftValue);
        int n = year = period.getYears() > 0 ? period.getYears() : -1 * period.getYears();
        int n2 = period.getMonths() > 0 ? period.getMonths() : (month = -1 * period.getMonths() > 0 ? -1 * period.getMonths() : 1);
        int days = period.getDays() > 0 ? period.getDays() : (-1 * period.getDays() > 0 ? -1 * period.getDays() : 1);
        return LocalDate.of(year, month, days);
    }

    private List<LocalDate> buildLocalDateList(List<?> objectsList) {
        ArrayList<LocalDate> localDateList = new ArrayList<LocalDate>();
        for (Object object : objectsList) {
            LocalDate localDate;
            if (object == null) {
                localDateList.add(null);
                continue;
            }
            if (object instanceof LocalDate) {
                localDateList.add((LocalDate)object);
                continue;
            }
            if (object instanceof Date) {
                Date date = (Date)object;
                localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                localDateList.add(localDate);
                continue;
            }
            try {
                LocalDate localDate2 = LocalDate.parse(object.toString(), LiteralType.dateFormat);
                localDateList.add(localDate2);
            }
            catch (Exception e) {
                try {
                    localDate = LocalDate.parse(object.toString(), LiteralType.dateTimeFormat);
                    localDateList.add(localDate);
                }
                catch (Exception e2) {
                    try {
                        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("E MMM dd hh:mm:ss Z yyyy");
                        LocalDate localDate3 = LocalDate.parse(object.toString(), dateTimeFormatter);
                        localDateList.add(localDate3);
                    }
                    catch (Exception e3) {
                        localDateList.add(null);
                    }
                }
            }
        }
        return localDateList;
    }
}

