/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.datatype;

import java.util.ArrayList;
import java.util.List;
import org.dvare.annotations.OperationMapping;
import org.dvare.annotations.Type;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.operation.aggregation.Maximum;
import org.dvare.expression.operation.aggregation.Minimum;
import org.dvare.expression.operation.aggregation.Sum;
import org.dvare.expression.operation.arithmetic.Add;
import org.dvare.expression.operation.arithmetic.Divide;
import org.dvare.expression.operation.arithmetic.Max;
import org.dvare.expression.operation.arithmetic.Min;
import org.dvare.expression.operation.arithmetic.Multiply;
import org.dvare.expression.operation.arithmetic.Power;
import org.dvare.expression.operation.arithmetic.Subtract;
import org.dvare.expression.operation.validation.Between;
import org.dvare.expression.operation.validation.Equals;
import org.dvare.expression.operation.validation.GreaterEqual;
import org.dvare.expression.operation.validation.GreaterThen;
import org.dvare.expression.operation.validation.In;
import org.dvare.expression.operation.validation.LessEqual;
import org.dvare.expression.operation.validation.LessThen;
import org.dvare.expression.operation.validation.NotEquals;
import org.dvare.expression.operation.validation.NotIn;

@Type(dataType=DataType.FloatType)
public class FloatType
extends DataTypeExpression {
    public FloatType() {
        super(DataType.FloatType);
    }

    @OperationMapping(operations={Equals.class})
    public boolean equal(LiteralExpression left, LiteralExpression right) {
        Float rightValue;
        Float leftValue = (Float)left.getValue();
        return leftValue.compareTo(rightValue = (Float)right.getValue()) == 0;
    }

    @OperationMapping(operations={NotEquals.class})
    public boolean notEqual(LiteralExpression left, LiteralExpression right) {
        Float rightValue;
        Float leftValue = (Float)left.getValue();
        return leftValue.compareTo(rightValue = (Float)right.getValue()) != 0;
    }

    @OperationMapping(operations={LessThen.class})
    public boolean less(LiteralExpression left, LiteralExpression right) {
        Float leftValue = (Float)left.getValue();
        Float rightValue = (Float)right.getValue();
        return leftValue.floatValue() < rightValue.floatValue();
    }

    @OperationMapping(operations={LessEqual.class})
    public boolean lessEqual(LiteralExpression left, LiteralExpression right) {
        Float leftValue = (Float)left.getValue();
        Float rightValue = (Float)right.getValue();
        return leftValue.floatValue() <= rightValue.floatValue();
    }

    @OperationMapping(operations={GreaterThen.class})
    public boolean greater(LiteralExpression left, LiteralExpression right) {
        Float leftValue = (Float)left.getValue();
        Float rightValue = (Float)right.getValue();
        return leftValue.floatValue() > rightValue.floatValue();
    }

    @OperationMapping(operations={GreaterEqual.class})
    public boolean greaterEqual(LiteralExpression left, LiteralExpression right) {
        Float leftValue = (Float)left.getValue();
        Float rightValue = (Float)right.getValue();
        return leftValue.floatValue() >= rightValue.floatValue();
    }

    @OperationMapping(operations={In.class})
    public boolean in(LiteralExpression left, LiteralExpression right) {
        Float leftValue = (Float)left.getValue();
        List<Float> rightValues = this.buildFloatList((List)right.getValue());
        return rightValues.contains(leftValue);
    }

    @OperationMapping(operations={NotIn.class})
    public boolean notIn(LiteralExpression left, LiteralExpression right) {
        Float leftValue = (Float)left.getValue();
        List<Float> rightValues = this.buildFloatList((List)right.getValue());
        return !rightValues.contains(leftValue);
    }

    @OperationMapping(operations={Between.class})
    public boolean between(LiteralExpression left, LiteralExpression right) {
        Float leftValue = (Float)left.getValue();
        List<Float> rightValues = this.buildFloatList((List)right.getValue());
        Float lower = rightValues.get(0);
        Float upper = rightValues.get(1);
        return lower.floatValue() <= leftValue.floatValue() && leftValue.floatValue() <= upper.floatValue();
    }

    @OperationMapping(operations={Sum.class, Add.class})
    public Float sum(LiteralExpression left, LiteralExpression right) {
        Float leftValue = (Float)left.getValue();
        Float rightValue = (Float)right.getValue();
        return Float.valueOf(leftValue.floatValue() + rightValue.floatValue());
    }

    @OperationMapping(operations={Subtract.class})
    public Float sub(LiteralExpression left, LiteralExpression right) {
        Float leftValue = (Float)left.getValue();
        Float rightValue = (Float)right.getValue();
        return Float.valueOf(leftValue.floatValue() - rightValue.floatValue());
    }

    @OperationMapping(operations={Multiply.class})
    public Float mul(LiteralExpression left, LiteralExpression right) {
        Float leftValue = (Float)left.getValue();
        Float rightValue = (Float)right.getValue();
        return Float.valueOf(leftValue.floatValue() * rightValue.floatValue());
    }

    @OperationMapping(operations={Divide.class})
    public Float div(LiteralExpression left, LiteralExpression right) {
        Float leftValue = (Float)left.getValue();
        Float rightValue = (Float)right.getValue();
        return Float.valueOf(leftValue.floatValue() / rightValue.floatValue());
    }

    @OperationMapping(operations={Power.class})
    public Float pow(LiteralExpression left, LiteralExpression right) {
        Float leftValue = (Float)left.getValue();
        if (right.getValue() instanceof Integer) {
            return new Float(Math.pow(leftValue.floatValue(), ((Integer)right.getValue()).intValue()));
        }
        if (right.getValue() instanceof Float) {
            return new Float(Math.pow(leftValue.floatValue(), ((Float)right.getValue()).floatValue()));
        }
        return null;
    }

    @OperationMapping(operations={Minimum.class, Min.class})
    public Float min(LiteralExpression left, LiteralExpression right) {
        Float leftValue = (Float)left.getValue();
        Float rightValue = (Float)right.getValue();
        return Float.valueOf(Float.min(leftValue.floatValue(), rightValue.floatValue()));
    }

    @OperationMapping(operations={Maximum.class, Max.class})
    public Float max(LiteralExpression left, LiteralExpression right) {
        Float leftValue = (Float)left.getValue();
        Float rightValue = (Float)right.getValue();
        return Float.valueOf(Float.max(leftValue.floatValue(), rightValue.floatValue()));
    }

    private List<Float> buildFloatList(List<Object> tempValues) {
        ArrayList<Float> values = new ArrayList<Float>();
        for (Object tempValue : tempValues) {
            if (tempValue instanceof Float) {
                values.add((Float)tempValue);
                continue;
            }
            try {
                Float value = Float.valueOf(Float.parseFloat(tempValue.toString()));
                values.add(value);
            }
            catch (NumberFormatException e) {
                values.add(null);
            }
            catch (NullPointerException e) {
                values.add(null);
            }
        }
        return values;
    }
}

