/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.datatype;

import java.util.ArrayList;
import java.util.List;
import org.dvare.annotations.OperationMapping;
import org.dvare.annotations.Type;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.operation.aggregation.Maximum;
import org.dvare.expression.operation.aggregation.Minimum;
import org.dvare.expression.operation.aggregation.Sum;
import org.dvare.expression.operation.arithmetic.Add;
import org.dvare.expression.operation.arithmetic.Divide;
import org.dvare.expression.operation.arithmetic.Max;
import org.dvare.expression.operation.arithmetic.Min;
import org.dvare.expression.operation.arithmetic.Multiply;
import org.dvare.expression.operation.arithmetic.Power;
import org.dvare.expression.operation.arithmetic.Subtract;
import org.dvare.expression.operation.validation.Between;
import org.dvare.expression.operation.validation.Equals;
import org.dvare.expression.operation.validation.GreaterEqual;
import org.dvare.expression.operation.validation.GreaterThen;
import org.dvare.expression.operation.validation.In;
import org.dvare.expression.operation.validation.LessEqual;
import org.dvare.expression.operation.validation.LessThen;
import org.dvare.expression.operation.validation.NotEquals;
import org.dvare.expression.operation.validation.NotIn;

@Type(dataType=DataType.IntegerType)
public class IntegerType
extends DataTypeExpression {
    public IntegerType() {
        super(DataType.IntegerType);
    }

    @OperationMapping(operations={Equals.class})
    public boolean equal(LiteralExpression left, LiteralExpression right) {
        Integer leftValue = (Integer)left.getValue();
        Integer rightValue = (Integer)right.getValue();
        return leftValue.equals(rightValue);
    }

    @OperationMapping(operations={NotEquals.class})
    public boolean notEqual(LiteralExpression left, LiteralExpression right) {
        Integer rightValue;
        Integer leftValue = (Integer)left.getValue();
        return !leftValue.equals(rightValue = (Integer)right.getValue());
    }

    @OperationMapping(operations={LessThen.class})
    public boolean less(LiteralExpression left, LiteralExpression right) {
        Integer leftValue = (Integer)left.getValue();
        Integer rightValue = (Integer)right.getValue();
        return leftValue < rightValue;
    }

    @OperationMapping(operations={LessEqual.class})
    public boolean lessEqual(LiteralExpression left, LiteralExpression right) {
        Integer leftValue = (Integer)left.getValue();
        Integer rightValue = (Integer)right.getValue();
        return leftValue <= rightValue;
    }

    @OperationMapping(operations={GreaterThen.class})
    public boolean greater(LiteralExpression left, LiteralExpression right) {
        Integer leftValue = (Integer)left.getValue();
        Integer rightValue = (Integer)right.getValue();
        return leftValue > rightValue;
    }

    @OperationMapping(operations={GreaterEqual.class})
    public boolean greaterEqual(LiteralExpression left, LiteralExpression right) {
        Integer leftValue = (Integer)left.getValue();
        Integer rightValue = (Integer)right.getValue();
        return leftValue >= rightValue;
    }

    @OperationMapping(operations={In.class})
    public boolean in(LiteralExpression left, LiteralExpression right) {
        Integer leftValue = (Integer)left.getValue();
        List<Integer> rightValues = this.buildIntegerList((List)right.getValue());
        return rightValues.contains(leftValue);
    }

    @OperationMapping(operations={NotIn.class})
    public boolean notIn(LiteralExpression left, LiteralExpression right) {
        Integer leftValue = (Integer)left.getValue();
        List<Integer> rightValues = this.buildIntegerList((List)right.getValue());
        return !rightValues.contains(leftValue);
    }

    @OperationMapping(operations={Between.class})
    public boolean between(LiteralExpression left, LiteralExpression right) {
        Integer leftValue = (Integer)left.getValue();
        List<Integer> rightValues = this.buildIntegerList((List)right.getValue());
        Integer lower = rightValues.get(0);
        Integer upper = rightValues.get(1);
        return lower <= leftValue && leftValue <= upper;
    }

    @OperationMapping(operations={Sum.class, Add.class})
    public Integer sum(LiteralExpression left, LiteralExpression right) {
        Integer leftValue = (Integer)left.getValue();
        Integer rightValue = (Integer)right.getValue();
        return leftValue + rightValue;
    }

    @OperationMapping(operations={Subtract.class})
    public Integer sub(LiteralExpression left, LiteralExpression right) {
        Integer leftValue = (Integer)left.getValue();
        Integer rightValue = (Integer)right.getValue();
        return leftValue - rightValue;
    }

    @OperationMapping(operations={Multiply.class})
    public Integer mul(LiteralExpression left, LiteralExpression right) {
        Integer leftValue = (Integer)left.getValue();
        Integer rightValue = (Integer)right.getValue();
        return leftValue * rightValue;
    }

    @OperationMapping(operations={Divide.class})
    public Integer div(LiteralExpression left, LiteralExpression right) {
        Integer leftValue = (Integer)left.getValue();
        Integer rightValue = (Integer)right.getValue();
        return leftValue / rightValue;
    }

    @OperationMapping(operations={Power.class})
    public Integer pow(LiteralExpression left, LiteralExpression right) {
        Integer leftValue = (Integer)left.getValue();
        if (right.getValue() instanceof Integer) {
            return (int)Math.pow(leftValue.intValue(), ((Integer)right.getValue()).intValue());
        }
        if (right.getValue() instanceof Float) {
            return (int)Math.pow(leftValue.intValue(), ((Float)right.getValue()).floatValue());
        }
        return null;
    }

    @OperationMapping(operations={Minimum.class, Min.class})
    public Integer min(LiteralExpression left, LiteralExpression right) {
        Integer leftValue = (Integer)left.getValue();
        Integer rightValue = (Integer)right.getValue();
        return Integer.min(leftValue, rightValue);
    }

    @OperationMapping(operations={Maximum.class, Max.class})
    public Integer max(LiteralExpression left, LiteralExpression right) {
        Integer leftValue = (Integer)left.getValue();
        Integer rightValue = (Integer)right.getValue();
        return Integer.max(leftValue, rightValue);
    }

    private List<Integer> buildIntegerList(List<?> tempValues) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (Object tempValue : tempValues) {
            if (tempValue instanceof Integer) {
                values.add((Integer)tempValue);
                continue;
            }
            try {
                Integer value = Integer.parseInt(tempValue.toString());
                values.add(value);
            }
            catch (NullPointerException | NumberFormatException e) {
                values.add(null);
            }
        }
        return values;
    }
}

