/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.datatype;

import java.util.List;
import org.dvare.annotations.OperationMapping;
import org.dvare.annotations.Type;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.literal.ListLiteral;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.operation.validation.Equals;
import org.dvare.expression.operation.validation.In;
import org.dvare.expression.operation.validation.NotEquals;
import org.dvare.expression.operation.validation.NotIn;

@Type(dataType=DataType.ListType)
public class ListType
extends DataTypeExpression {
    public ListType() {
        super(DataType.ListType);
    }

    @OperationMapping(operations={Equals.class})
    public boolean equal(LiteralExpression left, LiteralExpression right) {
        if (left instanceof ListLiteral && right instanceof ListLiteral) {
            List leftValues = (List)((ListLiteral)left).getValue();
            List rightValues = (List)((ListLiteral)right).getValue();
            return leftValues.equals(rightValues);
        }
        return false;
    }

    @OperationMapping(operations={NotEquals.class})
    public boolean notEqual(LiteralExpression left, LiteralExpression right) {
        return !this.equal(left, right);
    }

    @OperationMapping(operations={In.class})
    public boolean in(LiteralExpression left, LiteralExpression right) {
        if (left instanceof ListLiteral && right instanceof ListLiteral) {
            List leftValues = (List)((ListLiteral)left).getValue();
            List rightValues = (List)((ListLiteral)right).getValue();
            return leftValues.containsAll(rightValues);
        }
        return false;
    }

    @OperationMapping(operations={NotIn.class})
    public boolean notIn(LiteralExpression left, LiteralExpression right) {
        return !this.in(left, right);
    }
}

