/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.datatype;

import java.util.ArrayList;
import java.util.List;
import org.dvare.annotations.OperationMapping;
import org.dvare.annotations.Type;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.operation.validation.Equals;
import org.dvare.expression.operation.validation.In;
import org.dvare.expression.operation.validation.NotEquals;
import org.dvare.expression.operation.validation.NotIn;
import org.dvare.util.TrimString;

@Type(dataType=DataType.RegexType)
public class RegexType
extends DataTypeExpression {
    public RegexType() {
        super(DataType.RegexType);
    }

    @OperationMapping(operations={Equals.class})
    public boolean equal(LiteralExpression left, LiteralExpression right) {
        String rightValue;
        String leftValue = (String)left.getValue();
        return !leftValue.matches(rightValue = (String)right.getValue());
    }

    @OperationMapping(operations={NotEquals.class})
    public boolean notEqual(LiteralExpression left, LiteralExpression right) {
        String rightValue;
        String leftValue = (String)left.getValue();
        return !leftValue.matches(rightValue = (String)right.getValue());
    }

    @OperationMapping(operations={In.class})
    public boolean in(LiteralExpression left, LiteralExpression right) {
        String leftValue = (String)left.getValue();
        List tempValues = (List)right.getValue();
        ArrayList<String> values = new ArrayList<String>();
        for (Object tempValue : tempValues) {
            values.add(tempValue.toString());
        }
        for (String rightValue : values) {
            if (!leftValue.matches(rightValue = TrimString.trim(rightValue))) continue;
            return true;
        }
        return false;
    }

    @OperationMapping(operations={NotIn.class})
    public boolean notIn(LiteralExpression left, LiteralExpression right) {
        return !this.in(left, right);
    }
}

