/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.datatype;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dvare.annotations.OperationMapping;
import org.dvare.annotations.Type;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.operation.validation.Between;
import org.dvare.expression.operation.validation.Equals;
import org.dvare.expression.operation.validation.GreaterEqual;
import org.dvare.expression.operation.validation.GreaterThen;
import org.dvare.expression.operation.validation.In;
import org.dvare.expression.operation.validation.LessEqual;
import org.dvare.expression.operation.validation.LessThen;
import org.dvare.expression.operation.validation.NotEquals;
import org.dvare.expression.operation.validation.NotIn;

@Type(dataType=DataType.SimpleDateType)
public class SimpleDateType
extends DataTypeExpression {
    public static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("dd-MM-yyyy-HH:mm:ss");
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");

    public SimpleDateType() {
        super(DataType.SimpleDateType);
    }

    @OperationMapping(operations={Equals.class})
    public boolean equal(LiteralExpression left, LiteralExpression right) {
        Date leftValue = this.toLocalDate(left.getValue());
        Date rightValue = this.toLocalDate(right.getValue());
        return leftValue != null && rightValue != null && leftValue.compareTo(rightValue) == 0;
    }

    @OperationMapping(operations={NotEquals.class})
    public boolean notEqual(LiteralExpression left, LiteralExpression right) {
        Date leftValue = this.toLocalDate(left.getValue());
        Date rightValue = this.toLocalDate(right.getValue());
        return leftValue != null && rightValue != null && leftValue.compareTo(rightValue) != 0;
    }

    @OperationMapping(operations={LessThen.class})
    public boolean less(LiteralExpression left, LiteralExpression right) {
        Date leftValue = this.toLocalDate(left.getValue());
        Date rightValue = this.toLocalDate(right.getValue());
        return leftValue != null && rightValue != null && leftValue.compareTo(rightValue) < 0;
    }

    @OperationMapping(operations={LessEqual.class})
    public boolean lessEqual(LiteralExpression left, LiteralExpression right) {
        Date leftValue = this.toLocalDate(left.getValue());
        Date rightValue = this.toLocalDate(right.getValue());
        return leftValue != null && rightValue != null && leftValue.compareTo(rightValue) <= 0;
    }

    @OperationMapping(operations={GreaterThen.class})
    public boolean greater(LiteralExpression left, LiteralExpression right) {
        Date leftValue = this.toLocalDate(left.getValue());
        Date rightValue = this.toLocalDate(right.getValue());
        return leftValue != null && rightValue != null && leftValue.compareTo(rightValue) > 0;
    }

    @OperationMapping(operations={GreaterEqual.class})
    public boolean greaterEqual(LiteralExpression left, LiteralExpression right) {
        Date leftValue = this.toLocalDate(left.getValue());
        Date rightValue = this.toLocalDate(right.getValue());
        return leftValue != null && rightValue != null && leftValue.compareTo(rightValue) >= 0;
    }

    @OperationMapping(operations={In.class})
    public boolean in(LiteralExpression left, LiteralExpression right) {
        Date leftValue = this.toLocalDate(left.getValue());
        List<Date> rightValues = this.buildDateList((List)right.getValue());
        return leftValue != null && rightValues.contains(leftValue);
    }

    @OperationMapping(operations={NotIn.class})
    public boolean notIn(LiteralExpression left, LiteralExpression right) {
        Date leftValue = this.toLocalDate(left.getValue());
        List<Date> rightValues = this.buildDateList((List)right.getValue());
        return leftValue != null && !rightValues.contains(leftValue);
    }

    @OperationMapping(operations={Between.class})
    public boolean between(LiteralExpression left, LiteralExpression right) {
        Date leftValue = this.toLocalDate(left.getValue());
        List<Date> values = this.buildDateList((List)right.getValue());
        Date lower = values.get(0);
        Date upper = values.get(1);
        return leftValue != null && lower.compareTo(leftValue) <= 0 && leftValue.compareTo(upper) <= 0;
    }

    private Date toLocalDate(Object value) {
        if (value instanceof LocalDate) {
            LocalDate localDate = (LocalDate)value;
            return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)value;
            return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        return null;
    }

    private List<Date> buildDateList(List<?> tempValues) {
        ArrayList<Date> values = new ArrayList<Date>();
        for (Object tempValue : tempValues) {
            Date date;
            if (tempValue instanceof LocalDate) {
                LocalDate localDate = (LocalDate)tempValue;
                date = Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                values.add(date);
                continue;
            }
            if (tempValue instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)tempValue;
                date = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
                values.add(date);
                continue;
            }
            if (tempValue instanceof Date) {
                values.add((Date)tempValue);
                continue;
            }
            try {
                Date value = dateFormat.parse(tempValue.toString());
                values.add(value);
            }
            catch (ParseException e) {
                try {
                    Date value = dateTimeFormat.parse(tempValue.toString());
                    values.add(value);
                }
                catch (ParseException e2) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("E MMM dd hh:mm:ss Z yyyy");
                        Date value = simpleDateFormat.parse(tempValue.toString());
                        values.add(value);
                    }
                    catch (ParseException e3) {
                        values.add(null);
                    }
                }
            }
            catch (Exception e) {
                values.add(null);
            }
        }
        return values;
    }
}

