/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.datatype;

import java.util.ArrayList;
import java.util.List;
import org.dvare.annotations.OperationMapping;
import org.dvare.annotations.Type;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.datatype.RegexType;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.operation.validation.Equals;
import org.dvare.expression.operation.validation.GreaterEqual;
import org.dvare.expression.operation.validation.GreaterThen;
import org.dvare.expression.operation.validation.In;
import org.dvare.expression.operation.validation.LessEqual;
import org.dvare.expression.operation.validation.LessThen;
import org.dvare.expression.operation.validation.NotEquals;
import org.dvare.expression.operation.validation.NotIn;
import org.dvare.util.TrimString;

@Type(dataType=DataType.StringType)
public class StringType
extends DataTypeExpression {
    public StringType() {
        super(DataType.StringType);
    }

    @OperationMapping(operations={Equals.class})
    public boolean equal(LiteralExpression left, LiteralExpression right) {
        String leftValue = left.getValue().toString();
        String rightValue = right.getValue().toString();
        leftValue = TrimString.trim(leftValue);
        rightValue = TrimString.trim(rightValue);
        return right.getType().equals(StringType.class) ? leftValue.equals(rightValue) : right.getType().equals(RegexType.class) && leftValue.matches(rightValue);
    }

    @OperationMapping(operations={NotEquals.class})
    public boolean notEqual(LiteralExpression left, LiteralExpression right) {
        String leftValue = left.getValue().toString();
        String rightValue = right.getValue().toString();
        leftValue = TrimString.trim(leftValue);
        rightValue = TrimString.trim(rightValue);
        return right.getType().equals(StringType.class) ? !leftValue.equals(rightValue) : right.getType().equals(RegexType.class) && !leftValue.matches(rightValue);
    }

    @OperationMapping(operations={LessThen.class})
    public boolean less(LiteralExpression left, LiteralExpression right) {
        String leftValue = left.getValue().toString();
        String rightValue = right.getValue().toString();
        return leftValue.length() < rightValue.length();
    }

    @OperationMapping(operations={LessEqual.class})
    public boolean lessEqual(LiteralExpression left, LiteralExpression right) {
        String leftValue = left.getValue().toString();
        String rightValue = right.getValue().toString();
        return leftValue.length() <= rightValue.length();
    }

    @OperationMapping(operations={GreaterThen.class})
    public boolean greater(LiteralExpression left, LiteralExpression right) {
        String leftValue = left.getValue().toString();
        String rightValue = right.getValue().toString();
        return leftValue.length() > rightValue.length();
    }

    @OperationMapping(operations={GreaterEqual.class})
    public boolean greaterEqual(LiteralExpression left, LiteralExpression right) {
        String leftValue = (String)left.getValue();
        String rightValue = (String)right.getValue();
        return leftValue.length() >= rightValue.length();
    }

    @OperationMapping(operations={In.class})
    public boolean in(LiteralExpression left, LiteralExpression right) {
        String leftValue = left.getValue().toString();
        List tempValues = (List)right.getValue();
        ArrayList<String> values = new ArrayList<String>();
        for (Object tempValue : tempValues) {
            if (tempValue == null) {
                values.add(null);
                continue;
            }
            values.add(tempValue.toString());
        }
        leftValue = TrimString.trim(leftValue);
        for (String rightValue : values) {
            rightValue = TrimString.trim(rightValue);
            if (right.getType().equals(StringType.class) && leftValue.equals(rightValue)) {
                return true;
            }
            if (!right.getType().equals(RegexType.class) || !leftValue.matches(rightValue)) continue;
            return true;
        }
        return false;
    }

    @OperationMapping(operations={NotIn.class})
    public boolean notIn(LiteralExpression left, LiteralExpression right) {
        return !this.in(left, right);
    }
}

