/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.literal;

import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.datatype.RegexType;
import org.dvare.expression.datatype.StringType;
import org.dvare.util.TrimString;

public abstract class LiteralExpression<T>
extends Expression {
    protected T value;
    protected Class<? extends DataTypeExpression> type;

    LiteralExpression(T value, Class<? extends DataTypeExpression> type) {
        this.value = value;
        this.type = type;
    }

    public T getValue() {
        return this.value;
    }

    public Class<? extends DataTypeExpression> getType() {
        return this.type;
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        return this;
    }

    public String toString() {
        if (this.value == null) {
            return "null";
        }
        if (this.type.equals(StringType.class) || this.type.equals(RegexType.class)) {
            return "'" + TrimString.trim(this.value.toString()) + "'";
        }
        return this.value.toString();
    }
}

