/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.binding.model.TypeBinding;
import org.dvare.config.ConfigurationRegistry;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.NullType;
import org.dvare.expression.literal.ListLiteral;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.ChainOperationExpression;
import org.dvare.expression.operation.ListLiteralOperationExpression;
import org.dvare.expression.operation.ListOperationExpression;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.operation.utility.GetExpOperation;
import org.dvare.expression.operation.utility.Semicolon;
import org.dvare.expression.operation.validation.LeftPriority;
import org.dvare.expression.operation.validation.RightPriority;
import org.dvare.expression.veriable.ListVariable;
import org.dvare.expression.veriable.VariableExpression;
import org.dvare.expression.veriable.VariableType;
import org.dvare.util.TypeFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AggregationOperationExpression
extends OperationExpression {
    private static Logger logger = LoggerFactory.getLogger(AggregationOperationExpression.class);
    protected List<Expression> rightOperand = new ArrayList<Expression>();
    protected LiteralExpression leftExpression;

    public AggregationOperationExpression(OperationType operationType) {
        super(operationType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Integer parse(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        String token = tokens[pos - 1];
        if (stack.isEmpty()) {
            ConfigurationRegistry configurationRegistry = ConfigurationRegistry.INSTANCE;
            OperationExpression operationExpression = configurationRegistry.getOperation(token);
            if (operationExpression != null) {
                if (operationExpression instanceof ListLiteralOperationExpression) {
                    pos = operationExpression.parse(tokens, pos, stack, expressionBinding, contexts);
                    this.leftOperand = stack.pop();
                }
            } else {
                OperationExpression.TokenType tokenType = AggregationOperationExpression.findDataObject(token, contexts);
                if (tokenType.type == null || contexts.getContext(tokenType.type) == null || TypeFinder.findType(tokenType.token, contexts.getContext(tokenType.type)) == null) throw new ExpressionParseException("Left Operand of Aggregation Operation must be List or Variable ");
                TypeBinding typeBinding = contexts.getContext(tokenType.type);
                DataType variableType = TypeFinder.findType(tokenType.token, typeBinding);
                this.leftOperand = VariableType.getVariableType(tokenType.token, variableType, tokenType.type);
            }
        } else {
            this.leftOperand = stack.pop();
        }
        pos = this.findNextExpression(tokens, pos + 1, stack, expressionBinding, contexts);
        if (logger.isDebugEnabled()) {
            logger.debug("Operation Expression Call Expression : {}", (Object)this.getClass().getSimpleName());
        }
        stack.push(this);
        return pos;
    }

    @Override
    public Integer findNextExpression(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        ConfigurationRegistry configurationRegistry = ConfigurationRegistry.INSTANCE;
        Stack<Expression> localStack = new Stack<Expression>();
        while (pos < tokens.length) {
            String token = tokens[pos];
            OperationExpression op = configurationRegistry.getOperation(token);
            if (op != null) {
                if (op.getClass().equals(RightPriority.class)) {
                    this.rightOperand = new ArrayList<Expression>(localStack);
                    return pos;
                }
                if (!op.getClass().equals(LeftPriority.class)) {
                    pos = op.parse(tokens, pos, localStack, expressionBinding, contexts);
                }
            } else {
                localStack.add(this.buildExpression(token, contexts));
            }
            ++pos;
        }
        return pos;
    }

    @Override
    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder();
        if (this.leftOperand != null) {
            toStringBuilder.append(this.leftOperand.toString());
            toStringBuilder.append(" ");
        }
        toStringBuilder.append(this.operationType.getSymbols().get(0));
        toStringBuilder.append(" ");
        if (this.rightOperand != null) {
            toStringBuilder.append(this.rightOperand.toString());
            toStringBuilder.append(" ");
        }
        return toStringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected List<Object> buildValues(Expression expression, ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        if (expression instanceof ListOperationExpression || expression instanceof GetExpOperation || expression instanceof Semicolon) {
            OperationExpression valuesOperation = (OperationExpression)expression;
            Object valuesResult = valuesOperation.interpret(expressionBinding, instancesBinding);
            if (valuesResult instanceof ListLiteral) {
                ListLiteral listLiteral = (ListLiteral)valuesResult;
                this.dataTypeExpression = listLiteral.getType();
                return (List)listLiteral.getValue();
            }
        } else {
            if (expression instanceof VariableExpression) {
                ArrayList<Object> dataSet;
                VariableExpression variableExpression = (VariableExpression)expression;
                if (variableExpression instanceof ListVariable) {
                    this.dataTypeExpression = variableExpression.getType();
                    Object instance = instancesBinding.getInstance(variableExpression.getOperandType());
                    variableExpression = VariableType.setVariableValue(variableExpression, instance);
                    return (List)((ListVariable)variableExpression).getValue();
                }
                this.dataTypeExpression = variableExpression.getType();
                Object instance = instancesBinding.getInstance(variableExpression.getOperandType());
                if (instance instanceof List) {
                    dataSet = (ArrayList<Object>)instance;
                } else {
                    dataSet = new ArrayList<Object>();
                    dataSet.add(instance);
                }
                ArrayList<Object> values = new ArrayList<Object>();
                for (Object e : dataSet) {
                    Object value = this.getValue(e, variableExpression.getName());
                    values.add(value);
                }
                return values;
            }
            if (expression instanceof ChainOperationExpression) {
                ChainOperationExpression operationExpression = (ChainOperationExpression)expression;
                Expression leftOperand = operationExpression.getLeftOperand();
                while (leftOperand instanceof ChainOperationExpression) {
                    leftOperand = ((ChainOperationExpression)leftOperand).getLeftOperand();
                }
                if (leftOperand instanceof VariableExpression) {
                    void var9_21;
                    VariableExpression variableExpression = (VariableExpression)leftOperand;
                    String operandType = variableExpression.getOperandType();
                    this.dataTypeExpression = variableExpression.getType();
                    Object instance = instancesBinding.getInstance(operandType);
                    if (instance instanceof List) {
                        List list = (List)instance;
                    } else {
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        arrayList.add(instance);
                    }
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (Object e : var9_21) {
                        instancesBinding.addInstance(operandType, e);
                        LiteralExpression literalExpression = (LiteralExpression)operationExpression.interpret(expressionBinding, instancesBinding);
                        if (literalExpression.getType() != null && !literalExpression.getType().equals(NullType.class)) {
                            this.dataTypeExpression = literalExpression.getType();
                        }
                        values.add(literalExpression.getValue());
                    }
                    instancesBinding.addInstance(operandType, instance);
                    return values;
                }
            }
        }
        return null;
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        List dataSet = (List)instancesBinding.getInstance("data");
        for (Object bindings : dataSet) {
            Expression right = this.leftOperand;
            LiteralExpression<?> literalExpression = null;
            if (right instanceof OperationExpression) {
                OperationExpression operation = (OperationExpression)right;
                literalExpression = (LiteralExpression<?>)operation.interpret(expressionBinding, instancesBinding);
            } else if (right instanceof VariableExpression) {
                VariableExpression variableExpression = (VariableExpression)right;
                variableExpression = VariableType.setVariableValue(variableExpression, bindings);
                literalExpression = LiteralType.getLiteralExpression(variableExpression.getValue(), variableExpression.getType());
            } else if (right instanceof LiteralExpression) {
                literalExpression = (LiteralExpression)right;
            }
            if (literalExpression != null && !(literalExpression instanceof NullLiteral)) {
                try {
                    this.leftExpression = literalExpression.getType().newInstance().evaluate(this, this.leftExpression, literalExpression);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Updating value of  by " + this.leftExpression.getValue());
                continue;
            }
            throw new InterpretException("Literal Expression is null");
        }
        return this.leftExpression;
    }
}

