/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation;

import org.dvare.annotations.Type;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.datatype.NullType;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.EqualityOperationExpression;
import org.dvare.expression.operation.OperationType;

public abstract class ArithmeticOperationExpression
extends EqualityOperationExpression {
    public ArithmeticOperationExpression(OperationType operationType) {
        super(operationType);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        this.interpretOperand(expressionBinding, instancesBinding);
        Expression leftExpression = this.leftValueOperand;
        if (leftExpression == null) {
            return new NullLiteral();
        }
        LiteralExpression rightExpression = (LiteralExpression)this.rightValueOperand;
        LiteralExpression<?> left = this.toLiteralExpression(leftExpression);
        LiteralExpression right = this.toLiteralExpression(rightExpression);
        if (left instanceof NullLiteral && right instanceof NullLiteral) {
            return new NullLiteral();
        }
        if (left instanceof NullLiteral && right.getType().isAnnotationPresent(Type.class)) {
            Type type = right.getType().getAnnotation(Type.class);
            switch (type.dataType()) {
                case FloatType: {
                    left = LiteralType.getLiteralExpression((Object)Float.valueOf(0.0f), right.getType());
                    break;
                }
                case IntegerType: {
                    left = LiteralType.getLiteralExpression((Object)0, right.getType());
                    break;
                }
                case StringType: {
                    left = LiteralType.getLiteralExpression((Object)"", right.getType());
                }
            }
        }
        if (left instanceof NullLiteral || right instanceof NullLiteral) {
            this.dataTypeExpression = NullType.class;
        }
        try {
            return ((DataTypeExpression)this.dataTypeExpression.newInstance()).evaluate(this, left, right);
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

