/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.binding.model.TypeBinding;
import org.dvare.config.ConfigurationRegistry;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.operation.validation.RightPriority;
import org.dvare.expression.veriable.VariableType;
import org.dvare.util.TypeFinder;

public abstract class ChainOperationExpression
extends OperationExpression {
    protected List<Expression> rightOperand = new ArrayList<Expression>();

    public ChainOperationExpression(OperationType operationType) {
        super(operationType);
    }

    private int parseOperands(String[] tokens, int pos, Stack<Expression> stack, ContextsBinding contexts) throws ExpressionParseException {
        String token = tokens[pos - 1];
        ++pos;
        if (stack.isEmpty()) {
            OperationExpression.TokenType tokenType = ChainOperationExpression.findDataObject(token, contexts);
            if (tokenType.type != null && contexts.getContext(tokenType.type) != null && TypeFinder.findType(tokenType.token, contexts.getContext(tokenType.type)) != null) {
                TypeBinding typeBinding = contexts.getContext(tokenType.type);
                DataType variableType = TypeFinder.findType(tokenType.token, typeBinding);
                this.leftOperand = VariableType.getVariableType(tokenType.token, variableType, tokenType.type);
            } else {
                this.leftOperand = LiteralType.getLiteralExpression(token);
            }
        } else {
            this.leftOperand = stack.pop();
        }
        return pos;
    }

    @Override
    public Integer parse(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        pos = this.parseOperands(tokens, pos, stack, contexts);
        pos = this.findNextExpression(tokens, pos + 1, stack, expressionBinding, contexts);
        if (logger.isDebugEnabled()) {
            logger.debug("Operation Expression Call Expression : {}", (Object)this.getClass().getSimpleName());
        }
        stack.push(this);
        return pos;
    }

    @Override
    public Integer findNextExpression(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        ConfigurationRegistry configurationRegistry = ConfigurationRegistry.INSTANCE;
        Stack<Expression> localStack = new Stack<Expression>();
        for (int newPos = pos; newPos < tokens.length; ++newPos) {
            String token = tokens[newPos];
            OperationExpression op = configurationRegistry.getOperation(token);
            if (op != null) {
                if (op.getClass().equals(RightPriority.class)) {
                    this.rightOperand = new ArrayList<Expression>(localStack);
                    return newPos;
                }
                newPos = op.parse(tokens, newPos, localStack, expressionBinding, contexts);
                continue;
            }
            Expression expression = this.buildExpression(token, contexts);
            localStack.add(expression);
        }
        throw new ExpressionParseException(this.getClass().getSimpleName() + " Closing Bracket Not Found at " + pos);
    }

    @Override
    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder();
        if (this.leftOperand != null) {
            toStringBuilder.append(this.leftOperand.toString());
            toStringBuilder.append(" ");
        }
        toStringBuilder.append(this.operationType.getSymbols().get(0));
        toStringBuilder.append(" ");
        if (this.rightOperand != null) {
            toStringBuilder.append(this.rightOperand.toString());
            toStringBuilder.append(" ");
        }
        return toStringBuilder.toString();
    }
}

