/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation;

import java.util.Stack;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.config.ConfigurationRegistry;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.expression.Expression;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;

public abstract class ConditionOperationExpression
extends OperationExpression {
    protected Expression condition = null;
    protected Expression thenOperand = null;
    protected Expression elseOperand = null;

    public ConditionOperationExpression(OperationType operationType) {
        super(operationType);
    }

    @Override
    public Integer parse(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        pos = this.findNextExpression(tokens, pos + 1, stack, expressionBinding, contexts);
        return pos;
    }

    @Override
    public Integer findNextExpression(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        ConfigurationRegistry configurationRegistry = ConfigurationRegistry.INSTANCE;
        for (int i = pos; i < tokens.length; ++i) {
            OperationExpression op = configurationRegistry.getOperation(tokens[i]);
            if (op == null) continue;
            i = op.parse(tokens, i, stack, expressionBinding, contexts);
            return i;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder();
        if (this.leftOperand != null) {
            toStringBuilder.append(this.leftOperand.toString());
            toStringBuilder.append(" ");
        }
        toStringBuilder.append(this.operationType.getSymbols().get(0));
        toStringBuilder.append(" ");
        if (this.condition != null) {
            toStringBuilder.append(" ");
            toStringBuilder.append(this.condition.toString());
            toStringBuilder.append(" ");
        }
        if (this.thenOperand != null) {
            toStringBuilder.append("THEN ");
            toStringBuilder.append(this.thenOperand.toString());
            toStringBuilder.append(" ");
        }
        if (this.elseOperand != null) {
            toStringBuilder.append("ELSE ");
            toStringBuilder.append(this.elseOperand.toString());
            toStringBuilder.append(" ");
        }
        if (this.rightOperand != null) {
            toStringBuilder.append(this.rightOperand.toString());
            toStringBuilder.append(" ");
        }
        return toStringBuilder.toString();
    }
}

