/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation;

import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.binding.model.TypeBinding;
import org.dvare.config.ConfigurationRegistry;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.exceptions.parser.IllegalOperationException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.datatype.NullType;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.AggregationOperationExpression;
import org.dvare.expression.operation.AssignOperationExpression;
import org.dvare.expression.operation.ChainOperationExpression;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.operation.utility.Semicolon;
import org.dvare.expression.veriable.VariableExpression;
import org.dvare.expression.veriable.VariableType;
import org.dvare.parser.ExpressionTokenizer;
import org.dvare.util.TypeFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EqualityOperationExpression
extends OperationExpression {
    protected static Logger logger = LoggerFactory.getLogger(EqualityOperationExpression.class);

    public EqualityOperationExpression(OperationType operationType) {
        super(operationType);
    }

    protected boolean isLegalOperation(DataType dataType) {
        Operation operation;
        DataType[] dataTypes;
        Operation annotation = this.getClass().getAnnotation(Operation.class);
        return annotation != null && Arrays.asList(dataTypes = (operation = annotation).dataTypes()).contains((Object)dataType);
    }

    private int expression(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts, OperationExpression.TokenType tokenType) throws ExpressionParseException {
        ConfigurationRegistry configurationRegistry;
        OperationExpression nextOpp;
        Expression expression;
        OperationExpression op = ConfigurationRegistry.INSTANCE.getOperation(tokenType.token);
        if (op != null) {
            pos = op.parse(tokens, pos + 1, stack, expressionBinding, contexts);
            expression = stack.pop();
        } else if (tokenType.type != null && contexts.getContext(tokenType.type) != null && TypeFinder.findType(tokenType.token, contexts.getContext(tokenType.type)) != null) {
            TypeBinding typeBinding = contexts.getContext(tokenType.type);
            DataType variableType = TypeFinder.findType(tokenType.token, typeBinding);
            expression = VariableType.getVariableType(tokenType.token, variableType, tokenType.type);
        } else {
            expression = LiteralType.getLiteralExpression(tokenType.token);
        }
        if (pos + 1 < tokens.length && ((nextOpp = (configurationRegistry = ConfigurationRegistry.INSTANCE).getOperation(tokens[pos + 1])) instanceof ChainOperationExpression || nextOpp instanceof AggregationOperationExpression)) {
            stack.push(expression);
            pos = nextOpp.parse(tokens, pos + 1, stack, expressionBinding, contexts);
            expression = stack.pop();
        }
        stack.push(expression);
        return pos;
    }

    protected int parseOperands(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        String leftString = tokens[pos - 1];
        OperationExpression.TokenType leftTokenType = EqualityOperationExpression.findDataObject(leftString, contexts);
        if (stack.isEmpty() || stack.peek() instanceof AssignOperationExpression || stack.peek() instanceof Semicolon) {
            pos = this.expression(tokens, pos, stack, expressionBinding, contexts, leftTokenType);
        }
        this.leftOperand = stack.pop();
        String rightString = tokens[++pos];
        OperationExpression.TokenType rightTokenType = EqualityOperationExpression.findDataObject(rightString, contexts);
        pos = this.expression(tokens, pos, stack, expressionBinding, contexts, rightTokenType);
        this.rightOperand = stack.pop();
        return pos;
    }

    private void validate(Expression left, Expression right, String[] tokens, int pos) throws ExpressionParseException {
        if (left instanceof VariableExpression && right instanceof VariableExpression) {
            VariableExpression vL = (VariableExpression)left;
            VariableExpression vR = (VariableExpression)right;
            if (!this.toDataType(vL.getType()).equals((Object)this.toDataType(vR.getType()))) {
                String message = String.format("%s OperationExpression  not possible between  type %s and %s near %s", new Object[]{this.getClass().getSimpleName(), this.toDataType(vL.getType()), this.toDataType(vR.getType()), ExpressionTokenizer.toString(tokens, pos)});
                logger.error(message);
                throw new IllegalOperationException(message);
            }
        }
        if (!(left instanceof NullLiteral) && !(right instanceof NullLiteral)) {
            DataType leftDataType = null;
            DataType rightDataType = null;
            if (left instanceof VariableExpression) {
                leftDataType = this.toDataType(((VariableExpression)left).getType());
            } else if (left instanceof LiteralExpression) {
                leftDataType = this.toDataType(((LiteralExpression)left).getType());
            }
            if (right instanceof VariableExpression) {
                rightDataType = this.toDataType(((VariableExpression)right).getType());
            } else if (right instanceof LiteralExpression) {
                rightDataType = this.toDataType(((LiteralExpression)right).getType());
            }
            if (leftDataType != null && rightDataType != null) {
                if (leftDataType.equals((Object)DataType.StringType)) {
                    if (!rightDataType.equals((Object)DataType.StringType) && !rightDataType.equals((Object)DataType.RegexType)) {
                        String message = String.format("%s OperationExpression not possible between  type %s and %s near %s", new Object[]{this.getClass().getSimpleName(), leftDataType, rightDataType, ExpressionTokenizer.toString(tokens, pos)});
                        logger.error(message);
                        throw new IllegalOperationException(message);
                    }
                } else if (!leftDataType.equals((Object)rightDataType) && leftDataType != DataType.SimpleDateType && leftDataType != DataType.DateType && rightDataType != DataType.DateTimeType) {
                    String message = String.format("%s OperationExpression not possible between  type %s and %s near %s", new Object[]{this.getClass().getSimpleName(), leftDataType, rightDataType, ExpressionTokenizer.toString(tokens, pos)});
                    logger.error(message);
                    throw new IllegalOperationException(message);
                }
            }
            if (leftDataType != null && !this.isLegalOperation(leftDataType)) {
                String message = String.format("OperationExpression %s not possible on type %s at %s", new Object[]{this.getClass().getSimpleName(), leftDataType, ExpressionTokenizer.toString(tokens, pos)});
                logger.error(message);
                throw new IllegalOperationException(message);
            }
        }
    }

    @Override
    public Integer parse(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        if (pos - 1 >= 0 && tokens.length >= pos + 1) {
            pos = this.parseOperands(tokens, pos, stack, expressionBinding, contexts);
            Expression left = this.leftOperand;
            Expression right = this.rightOperand;
            this.validate(left, right, tokens, pos);
            if (logger.isDebugEnabled()) {
                logger.debug("OperationExpression Call Expression : {}", (Object)this.getClass().getSimpleName());
            }
            stack.push(this);
            return pos;
        }
        throw new ExpressionParseException("Cannot assign literal to variable");
    }

    @Override
    public Integer findNextExpression(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        ConfigurationRegistry configurationRegistry = ConfigurationRegistry.INSTANCE;
        while (pos < tokens.length) {
            OperationExpression op = configurationRegistry.getOperation(tokens[pos]);
            if (op != null) {
                pos = op.parse(tokens, pos, stack, expressionBinding, contexts);
                return pos;
            }
            ++pos;
        }
        return pos;
    }

    public void interpretOperand(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        Expression leftExpression = super.interpretOperand(this.leftOperand, expressionBinding, instancesBinding);
        Expression right = this.rightOperand;
        LiteralExpression<?> rightExpression = null;
        if (right instanceof OperationExpression) {
            OperationExpression operation = (OperationExpression)right;
            rightExpression = (LiteralExpression)operation.interpret(expressionBinding, instancesBinding);
        } else if (right instanceof LiteralExpression) {
            rightExpression = (LiteralExpression<?>)right;
        } else if (right instanceof VariableExpression) {
            VariableExpression variableExpression = (VariableExpression)right;
            Object instance = instancesBinding.getInstance(variableExpression.getOperandType());
            if (instance instanceof List) {
                instance = ((List)instance).isEmpty() ? null : ((List)instance).get(0);
            }
            variableExpression = VariableType.setVariableValue(variableExpression, instance);
            rightExpression = LiteralType.getLiteralExpression(variableExpression.getValue(), variableExpression.getType());
        }
        if (this.dataTypeExpression == null && rightExpression != null) {
            this.dataTypeExpression = rightExpression.getType();
        }
        this.leftValueOperand = leftExpression;
        this.rightValueOperand = rightExpression;
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        this.interpretOperand(expressionBinding, instancesBinding);
        if (this.leftValueOperand != null && this.rightValueOperand != null) {
            LiteralExpression left = this.toLiteralExpression(this.leftValueOperand);
            LiteralExpression right = this.toLiteralExpression(this.rightValueOperand);
            if (left instanceof NullLiteral || right instanceof NullLiteral) {
                this.dataTypeExpression = NullType.class;
            }
            try {
                return ((DataTypeExpression)this.dataTypeExpression.newInstance()).evaluate(this, left, right);
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }
}

