/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.binding.model.TypeBinding;
import org.dvare.config.ConfigurationRegistry;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.literal.ListLiteral;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.veriable.VariableExpression;
import org.dvare.expression.veriable.VariableType;
import org.dvare.util.TypeFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(type=OperationType.List)
public class ListLiteralOperationExpression
extends OperationExpression {
    protected static Logger logger = LoggerFactory.getLogger(ListLiteralOperationExpression.class);
    protected List<Expression> expressions = new ArrayList<Expression>();

    public ListLiteralOperationExpression() {
        super(OperationType.List);
    }

    @Override
    public Integer parse(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        int newPos = pos;
        ArrayList<String> listPrams = new ArrayList<String>();
        while (!tokens[newPos].equals("]")) {
            String value = tokens[newPos];
            if (!value.equals("[")) {
                listPrams.add(value);
            }
            if (++newPos != tokens.length) continue;
            throw new ExpressionParseException("Array Closing Bracket Not Found at " + pos);
        }
        String[] values = listPrams.toArray(new String[listPrams.size()]);
        Stack<Expression> localStack = new Stack<Expression>();
        ConfigurationRegistry configurationRegistry = ConfigurationRegistry.INSTANCE;
        for (int i = 0; i < values.length; ++i) {
            String token = values[i];
            OperationExpression.TokenType tokenType = ListLiteralOperationExpression.findDataObject(token, contexts);
            Expression expression = null;
            OperationExpression op = configurationRegistry.getOperation(token);
            if (op != null) {
                i = op.parse(values, i, localStack, expressionBinding, contexts);
                expression = localStack.pop();
            } else if (tokenType.type != null && contexts.getContext(tokenType.type) != null && TypeFinder.findType(tokenType.token, contexts.getContext(tokenType.type)) != null) {
                TypeBinding typeBinding = contexts.getContext(tokenType.type);
                DataType variableType = TypeFinder.findType(tokenType.token, typeBinding);
                expression = VariableType.getVariableType(tokenType.token, variableType, tokenType.type);
            } else {
                expression = LiteralType.getLiteralExpression(tokenType.token);
            }
            localStack.push(expression);
        }
        this.expressions.addAll(localStack);
        stack.push(this);
        return newPos;
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        Class<DataTypeExpression> dataType = null;
        ArrayList<Object> values = new ArrayList<Object>();
        for (Expression expression : this.expressions) {
            LiteralExpression<?> literalExpression;
            if (expression instanceof OperationExpression) {
                OperationExpression operationExpression = (OperationExpression)expression;
                Object interpret = operationExpression.interpret(expressionBinding, instancesBinding);
                if (interpret instanceof LiteralExpression) {
                    literalExpression = (LiteralExpression<?>)interpret;
                    values.add(literalExpression.getValue());
                    if (dataType != null && !this.toDataType(dataType).equals((Object)DataType.NullType)) continue;
                    dataType = literalExpression.getType();
                    continue;
                }
                values.add(interpret);
                continue;
            }
            if (expression instanceof VariableExpression) {
                VariableExpression variableExpression = (VariableExpression)expression;
                Object instance = instancesBinding.getInstance(variableExpression.getOperandType());
                variableExpression = VariableType.setVariableValue(variableExpression, instance);
                literalExpression = LiteralType.getLiteralExpression(variableExpression.getValue(), variableExpression.getType());
                values.add(literalExpression.getValue());
                dataType = variableExpression.getType();
                continue;
            }
            if (!(expression instanceof LiteralExpression)) continue;
            LiteralExpression literalExpression2 = (LiteralExpression)expression;
            values.add(literalExpression2.getValue());
            if (dataType != null && !this.toDataType(dataType).equals((Object)DataType.NullType)) continue;
            dataType = literalExpression2.getType();
        }
        ListLiteral listLiteral = new ListLiteral(values, (Class<? extends DataTypeExpression>)dataType);
        if (logger.isDebugEnabled()) {
            logger.debug("List Literal Expression : {} [{}]", (Object)this.toDataType(listLiteral.getType()), listLiteral.getValue());
        }
        return listLiteral;
    }

    public boolean isEmpty() {
        return this.expressions.isEmpty();
    }

    public Integer getSize() {
        return this.expressions.size();
    }

    @Override
    public Integer findNextExpression(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        return pos;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<Expression> iterator = this.expressions.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

