/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.dvare.binding.data.DataRow;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.BooleanExpression;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.BooleanType;
import org.dvare.expression.literal.BooleanLiteral;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.operation.AggregationOperationExpression;
import org.dvare.expression.operation.ChainOperationExpression;
import org.dvare.expression.operation.EqualityOperationExpression;
import org.dvare.expression.operation.LogicalOperationExpression;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.veriable.VariableExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ListOperationExpression
extends AggregationOperationExpression {
    private static Logger logger = LoggerFactory.getLogger(ListOperationExpression.class);

    public ListOperationExpression(OperationType operationType) {
        super(operationType);
    }

    protected boolean isPairList(List<Object> values) {
        return values.stream().allMatch(o -> o instanceof Pair);
    }

    protected List<Object> includedFilter(Expression includeParam, ExpressionBinding expressionBinding, InstancesBinding instancesBinding, List<Object> values) throws InterpretException {
        BooleanExpression booleanExpression;
        Boolean result;
        if (includeParam instanceof LogicalOperationExpression) {
            OperationExpression operationExpression = (OperationExpression)includeParam;
            Expression left = operationExpression.getLeftOperand();
            Expression right = operationExpression.getRightOperand();
            ArrayList<Object> includedValues = new ArrayList<Object>();
            for (Object value : values) {
                Boolean result2 = this.solveLogical(operationExpression, expressionBinding, instancesBinding, value);
                if (result2.booleanValue()) {
                    includedValues.add(value);
                }
                operationExpression.setLeftOperand(left);
                operationExpression.setRightOperand(right);
            }
            return includedValues;
        }
        if (includeParam instanceof EqualityOperationExpression || includeParam instanceof ChainOperationExpression) {
            ArrayList<Object> includedValues = new ArrayList<Object>();
            for (Object value : values) {
                Boolean result3 = this.buildEqualityOperationExpression(includeParam, expressionBinding, instancesBinding, value);
                if (!result3.booleanValue()) continue;
                includedValues.add(value);
            }
            return includedValues;
        }
        if (includeParam instanceof BooleanExpression && !(result = this.toBoolean((booleanExpression = (BooleanExpression)includeParam).interpret(expressionBinding, instancesBinding))).booleanValue()) {
            return new ArrayList<Object>();
        }
        return values;
    }

    protected List<Object> excludedFilter(Expression includeParam, Expression exculdeParam, ExpressionBinding expressionBinding, InstancesBinding instancesBinding, List<Object> values) throws InterpretException {
        List<Object> includedValues = this.includedFilter(includeParam, expressionBinding, instancesBinding, values);
        if (exculdeParam instanceof LogicalOperationExpression) {
            OperationExpression operationExpression = (OperationExpression)includeParam;
            Expression left = operationExpression.getLeftOperand();
            Expression right = operationExpression.getRightOperand();
            ArrayList<Object> excludedValues = new ArrayList<Object>();
            for (Object value : values) {
                Boolean result = this.solveLogical(operationExpression, expressionBinding, instancesBinding, value);
                if (result.booleanValue()) {
                    excludedValues.add(value);
                }
                operationExpression.setLeftOperand(left);
                operationExpression.setRightOperand(right);
            }
            includedValues.removeAll(excludedValues);
            return includedValues;
        }
        if (exculdeParam instanceof EqualityOperationExpression || exculdeParam instanceof ChainOperationExpression) {
            ArrayList<Object> excludedValues = new ArrayList<Object>();
            for (Object value : includedValues) {
                Boolean result = this.buildEqualityOperationExpression(exculdeParam, expressionBinding, instancesBinding, value);
                if (!result.booleanValue()) continue;
                excludedValues.add(value);
            }
            includedValues.removeAll(excludedValues);
        }
        return includedValues;
    }

    protected Boolean buildEqualityOperationExpression(Expression includeParam, ExpressionBinding expressionBinding, InstancesBinding instancesBinding, Object value) throws InterpretException {
        if (includeParam instanceof BooleanLiteral) {
            return this.toBoolean(includeParam);
        }
        OperationExpression operationExpression = (OperationExpression)includeParam;
        Expression leftExpression = operationExpression.getLeftOperand();
        while (leftExpression instanceof OperationExpression) {
            leftExpression = ((OperationExpression)leftExpression).getLeftOperand();
        }
        if (leftExpression instanceof VariableExpression) {
            DataRow dataRow;
            VariableExpression variableExpression = (VariableExpression)leftExpression;
            String name = variableExpression.getName();
            String operandType = variableExpression.getOperandType();
            Object instance = instancesBinding.getInstance(operandType);
            if (instance == null || !(instance instanceof DataRow)) {
                dataRow = new DataRow();
                dataRow.addData(name, value);
                instancesBinding.addInstance(operandType, dataRow);
            } else {
                dataRow = (DataRow)instance;
                dataRow.addData(name, value);
                instancesBinding.addInstance(operandType, dataRow);
            }
            Object interpret = operationExpression.interpret(expressionBinding, instancesBinding);
            return this.toBoolean(interpret);
        }
        return false;
    }

    protected Boolean solveLogical(OperationExpression operationExpression, ExpressionBinding expressionBinding, InstancesBinding instancesBinding, Object value) throws InterpretException {
        Boolean result;
        Expression left = operationExpression.getLeftOperand();
        Expression right = operationExpression.getRightOperand();
        if (left != null) {
            if (left instanceof LogicalOperationExpression) {
                result = this.solveLogical((OperationExpression)left, expressionBinding, instancesBinding, value);
                operationExpression.setLeftOperand(LiteralType.getLiteralExpression((Object)result, BooleanType.class));
            } else {
                result = this.buildEqualityOperationExpression(left, expressionBinding, instancesBinding, value);
                operationExpression.setLeftOperand(LiteralType.getLiteralExpression((Object)result, BooleanType.class));
            }
        }
        if (right != null) {
            if (right instanceof LogicalOperationExpression) {
                result = this.solveLogical((OperationExpression)right, expressionBinding, instancesBinding, value);
                operationExpression.setRightOperand(LiteralType.getLiteralExpression((Object)result, BooleanType.class));
            } else {
                result = this.buildEqualityOperationExpression(right, expressionBinding, instancesBinding, value);
                operationExpression.setRightOperand(LiteralType.getLiteralExpression((Object)result, BooleanType.class));
            }
        }
        result = this.toBoolean(operationExpression.interpret(expressionBinding, instancesBinding));
        operationExpression.setLeftOperand(left);
        operationExpression.setRightOperand(right);
        return result;
    }
}

