/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation;

import java.util.Stack;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.config.ConfigurationRegistry;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.expression.Expression;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.operation.condition.ENDIF;
import org.dvare.expression.operation.list.EndForAllEach;
import org.dvare.expression.operation.validation.RightPriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogicalOperationExpression
extends OperationExpression {
    protected static Logger logger = LoggerFactory.getLogger(LogicalOperationExpression.class);

    public LogicalOperationExpression(OperationType operationType) {
        super(operationType);
    }

    @Override
    public Integer parse(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        Expression left = stack.pop();
        pos = this.findNextExpression(tokens, pos + 1, stack, expressionBinding, contexts);
        Expression right = stack.pop();
        this.leftOperand = left;
        this.rightOperand = right;
        if (logger.isDebugEnabled()) {
            logger.debug("OperationExpression Call Expression : {}", (Object)this.getClass().getSimpleName());
        }
        stack.push(this);
        return pos;
    }

    @Override
    public Integer findNextExpression(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        ConfigurationRegistry configurationRegistry = ConfigurationRegistry.INSTANCE;
        while (pos < tokens.length) {
            OperationExpression op = configurationRegistry.getOperation(tokens[pos]);
            if (op != null) {
                OperationExpression testOp;
                if (op instanceof RightPriority || op instanceof EndForAllEach || op instanceof ENDIF) {
                    return pos - 1;
                }
                if ((pos = op.parse(tokens, pos, stack, expressionBinding, contexts).intValue()) + 1 < tokens.length && (testOp = configurationRegistry.getOperation(tokens[pos + 1])) instanceof LogicalOperationExpression) {
                    return pos;
                }
            }
            ++pos;
        }
        return pos;
    }
}

