/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation;

import java.util.List;
import java.util.Stack;
import org.dvare.annotations.Type;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.binding.model.TypeBinding;
import org.dvare.exceptions.interpreter.IllegalPropertyValueException;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.exceptions.parser.IllegalPropertyException;
import org.dvare.exceptions.parser.IllegalValueException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.veriable.VariableExpression;
import org.dvare.expression.veriable.VariableType;
import org.dvare.util.TypeFinder;
import org.dvare.util.ValueFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OperationExpression
extends Expression {
    protected static Logger logger = LoggerFactory.getLogger(OperationExpression.class);
    protected OperationType operationType;
    protected Expression leftOperand = null;
    protected Expression rightOperand = null;
    protected Class<? extends DataTypeExpression> dataTypeExpression;
    protected Expression leftValueOperand;
    protected Expression rightValueOperand;

    public OperationExpression(OperationType operationType) {
        this.operationType = operationType;
    }

    public static TokenType buildTokenType(String token) {
        TokenType tokenType = new TokenType();
        String selfPatten = ".{1,}\\..{1,}";
        if (!token.matches(".{1,}\\..{1,}")) {
            tokenType.token = token;
            tokenType.type = "self";
        } else {
            tokenType.type = token.substring(0, token.indexOf("."));
            tokenType.token = token.substring(token.indexOf(".") + 1, token.length());
        }
        return tokenType;
    }

    public static TokenType findDataObject(String token, ContextsBinding contexts) {
        TokenType tokenType = OperationExpression.buildTokenType(token);
        if (contexts.getContext(tokenType.type) != null && TypeFinder.findType(tokenType.token, contexts.getContext(tokenType.type)) != null) {
            return tokenType;
        }
        for (String key : contexts.getContextNames()) {
            TypeBinding typeBinding;
            if (key.equals("self") || (typeBinding = contexts.getContext(key)) == null || typeBinding.getDataType(token) == null) continue;
            tokenType.type = key;
            tokenType.token = token;
            return tokenType;
        }
        tokenType.type = null;
        tokenType.token = token;
        return tokenType;
    }

    public abstract Integer parse(String[] var1, int var2, Stack<Expression> var3, ExpressionBinding var4, ContextsBinding var5) throws ExpressionParseException;

    public abstract Integer findNextExpression(String[] var1, int var2, Stack<Expression> var3, ExpressionBinding var4, ContextsBinding var5) throws ExpressionParseException;

    protected Expression buildExpression(String token, ContextsBinding contextsBinding) throws IllegalPropertyException, IllegalValueException {
        TokenType tokenType = OperationExpression.findDataObject(token, contextsBinding);
        if (tokenType.type != null && contextsBinding.getContext(tokenType.type) != null && TypeFinder.findType(tokenType.token, contextsBinding.getContext(tokenType.type)) != null) {
            TypeBinding typeBinding = contextsBinding.getContext(tokenType.type);
            DataType variableType = TypeFinder.findType(tokenType.token, typeBinding);
            return VariableType.getVariableType(tokenType.token, variableType, tokenType.type);
        }
        return LiteralType.getLiteralExpression(token);
    }

    protected Object getValue(Object object, String name) throws IllegalPropertyValueException {
        return ValueFinder.findValue(name, object);
    }

    protected Object setValue(Object object, String name, Object value) throws IllegalPropertyValueException {
        return ValueFinder.updateValue(object, name, value);
    }

    protected DataType toDataType(Class<? extends DataTypeExpression> dataTypeExpression) {
        if (dataTypeExpression.isAnnotationPresent(Type.class)) {
            Type type = dataTypeExpression.getAnnotation(Type.class);
            return type.dataType();
        }
        return null;
    }

    public Expression interpretOperand(Expression expression, ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        Expression leftExpression = null;
        if (expression instanceof OperationExpression) {
            OperationExpression operation = (OperationExpression)expression;
            LiteralExpression literalExpression = (LiteralExpression)operation.interpret(expressionBinding, instancesBinding);
            if (literalExpression != null) {
                this.dataTypeExpression = literalExpression.getType();
            }
            leftExpression = literalExpression;
        } else if (expression instanceof VariableExpression) {
            VariableExpression variableExpression = (VariableExpression)expression;
            Object instance = instancesBinding.getInstance(variableExpression.getOperandType());
            if (instance instanceof List) {
                Object object = instance = ((List)instance).isEmpty() ? null : (Object)((List)instance).get(0);
            }
            if ((variableExpression = VariableType.setVariableValue(variableExpression, instance)) != null) {
                this.dataTypeExpression = variableExpression.getType();
            }
            leftExpression = variableExpression;
        } else if (expression instanceof LiteralExpression) {
            LiteralExpression literalExpression = (LiteralExpression)expression;
            this.dataTypeExpression = literalExpression.getType();
            leftExpression = literalExpression;
        }
        return leftExpression;
    }

    protected LiteralExpression toLiteralExpression(Expression expression) throws InterpretException {
        LiteralExpression<?> leftExpression = null;
        if (expression instanceof VariableExpression) {
            VariableExpression variableExpression = (VariableExpression)expression;
            leftExpression = LiteralType.getLiteralExpression(variableExpression.getValue(), variableExpression.getType());
        } else if (expression instanceof LiteralExpression) {
            leftExpression = (LiteralExpression<?>)expression;
        }
        return leftExpression;
    }

    protected Boolean toBoolean(Object interpret) {
        Boolean result = false;
        if (interpret instanceof LiteralExpression) {
            Object value;
            if (!(interpret instanceof NullLiteral) && ((LiteralExpression)interpret).getValue() != null && (value = ((LiteralExpression)interpret).getValue()) instanceof Boolean) {
                result = (Boolean)value;
            }
        } else if (interpret != null && interpret instanceof Boolean) {
            result = (Boolean)interpret;
        }
        return result;
    }

    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder();
        if (this.leftOperand != null) {
            toStringBuilder.append(this.leftOperand.toString());
            toStringBuilder.append(" ");
        }
        toStringBuilder.append(this.operationType.getSymbols().get(0));
        toStringBuilder.append(" ");
        if (this.rightOperand != null) {
            toStringBuilder.append(this.rightOperand.toString());
            toStringBuilder.append(" ");
        }
        return toStringBuilder.toString();
    }

    public Expression getLeftOperand() {
        return this.leftOperand;
    }

    public void setLeftOperand(Expression leftOperand) {
        this.leftOperand = leftOperand;
    }

    public Expression getRightOperand() {
        return this.rightOperand;
    }

    public void setRightOperand(Expression rightOperand) {
        this.rightOperand = rightOperand;
    }

    public List<String> getSymbols() {
        return this.operationType.getSymbols();
    }

    public static class TokenType {
        public String type;
        public String token;
    }
}

