/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.aggregation;

import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.AggregationOperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.veriable.VariableExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(type=OperationType.MAXIMUM, dataTypes={DataType.FloatType, DataType.IntegerType})
public class Maximum
extends AggregationOperationExpression {
    static Logger logger = LoggerFactory.getLogger(Maximum.class);

    public Maximum() {
        super(OperationType.MAXIMUM);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        Expression right = this.leftOperand;
        if (right instanceof VariableExpression) {
            VariableExpression variableExpression = (VariableExpression)right;
            DataType type = this.toDataType(variableExpression.getType());
            switch (type) {
                case FloatType: {
                    this.leftExpression = LiteralType.getLiteralExpression((Object)Float.valueOf(Float.MIN_VALUE), variableExpression.getType());
                    break;
                }
                case IntegerType: {
                    this.leftExpression = LiteralType.getLiteralExpression((Object)Integer.MIN_VALUE, variableExpression.getType());
                    break;
                }
                default: {
                    this.leftExpression = new NullLiteral();
                }
            }
        }
        return super.interpret(expressionBinding, instancesBinding);
    }
}

