/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.aggregation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.FloatType;
import org.dvare.expression.datatype.IntegerType;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.operation.AggregationOperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.veriable.VariableExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(type=OperationType.MEAN, dataTypes={DataType.FloatType, DataType.IntegerType})
public class Mean
extends AggregationOperationExpression {
    static Logger logger = LoggerFactory.getLogger(Mean.class);

    public Mean() {
        super(OperationType.MEAN);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        Expression right = this.leftOperand;
        if (right instanceof VariableExpression) {
            ArrayList<Object> dataSet;
            VariableExpression variableExpression = (VariableExpression)right;
            String name = variableExpression.getName();
            DataType type = this.toDataType(variableExpression.getType());
            Object instance = instancesBinding.getInstance(variableExpression.getOperandType());
            if (instance instanceof List) {
                dataSet = (ArrayList<Object>)instance;
            } else {
                dataSet = new ArrayList<Object>();
                dataSet.add(instance);
            }
            switch (type) {
                case FloatType: {
                    ArrayList<Float> values = new ArrayList<Float>();
                    for (Object e : dataSet) {
                        Object value = this.getValue(e, name);
                        if (!(value instanceof Float)) continue;
                        values.add((Float)value);
                    }
                    Collections.sort(values);
                    Float sum = Float.valueOf(0.0f);
                    for (Float i : values) {
                        sum = Float.valueOf(sum.floatValue() + i.floatValue());
                    }
                    Float f = Float.valueOf(sum.floatValue() / (float)values.size());
                    this.leftExpression = LiteralType.getLiteralExpression((Object)f, FloatType.class);
                    break;
                }
                case IntegerType: {
                    ArrayList<Integer> values = new ArrayList<Integer>();
                    for (Object e : dataSet) {
                        Object value = this.getValue(e, name);
                        if (!(value instanceof Integer)) continue;
                        values.add((Integer)value);
                    }
                    Collections.sort(values);
                    Object sum = 0;
                    for (Integer i : values) {
                        sum = (Integer)sum + i;
                    }
                    Integer n = (Integer)sum / values.size();
                    this.leftExpression = LiteralType.getLiteralExpression((Object)n, IntegerType.class);
                    break;
                }
            }
        }
        return this.leftExpression;
    }
}

