/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.aggregation;

import java.util.ArrayList;
import java.util.List;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.FloatType;
import org.dvare.expression.datatype.IntegerType;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.operation.AggregationOperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.veriable.VariableExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(type=OperationType.MEDIAN, dataTypes={DataType.FloatType, DataType.IntegerType})
public class Median
extends AggregationOperationExpression {
    static Logger logger = LoggerFactory.getLogger(Median.class);

    public Median() {
        super(OperationType.MEDIAN);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        Expression right = this.leftOperand;
        if (right instanceof VariableExpression) {
            ArrayList<Object> dataSet;
            VariableExpression variableExpression = (VariableExpression)right;
            String name = variableExpression.getName();
            DataType type = this.toDataType(variableExpression.getType());
            Object instance = instancesBinding.getInstance(variableExpression.getOperandType());
            if (instance instanceof List) {
                dataSet = (ArrayList<Object>)instance;
            } else {
                dataSet = new ArrayList<Object>();
                dataSet.add(instance);
            }
            int length = dataSet.size();
            int middle = length / 2;
            switch (type) {
                case FloatType: {
                    ArrayList<Float> values = new ArrayList<Float>();
                    for (Object e : dataSet) {
                        Object value = this.getValue(e, name);
                        if (!(value instanceof Float)) continue;
                        values.add((Float)value);
                    }
                    Float result = Float.valueOf(0.0f);
                    if (length % 2 == 1) {
                        result = (Float)values.get(middle);
                    } else {
                        Float f = (Float)values.get(middle - 1);
                        Float value2 = (Float)values.get(middle - 2);
                        result = Float.valueOf((f.floatValue() + value2.floatValue()) / 2.0f);
                    }
                    this.leftExpression = LiteralType.getLiteralExpression((Object)result, FloatType.class);
                    break;
                }
                case IntegerType: {
                    ArrayList<Integer> values = new ArrayList<Integer>();
                    for (Object e : dataSet) {
                        Object value = this.getValue(e, name);
                        if (!(value instanceof Integer)) continue;
                        values.add((Integer)value);
                    }
                    Object result = 0;
                    if (length % 2 == 1) {
                        result = (Integer)values.get(middle);
                    } else {
                        Integer n = (Integer)values.get(middle);
                        Integer value2 = (Integer)values.get(middle - 1);
                        result = (n + value2) / 2;
                    }
                    this.leftExpression = LiteralType.getLiteralExpression(result, IntegerType.class);
                    break;
                }
            }
        }
        return this.leftExpression;
    }
}

