/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.aggregation;

import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.AggregationOperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.veriable.VariableExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(type=OperationType.SUM, dataTypes={DataType.FloatType, DataType.IntegerType})
public class Sum
extends AggregationOperationExpression {
    static Logger logger = LoggerFactory.getLogger(Sum.class);

    public Sum() {
        super(OperationType.SUM);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        if (this.leftOperand instanceof VariableExpression) {
            VariableExpression variableExpression = (VariableExpression)this.leftOperand;
            DataType type = this.toDataType(variableExpression.getType());
            switch (type) {
                case FloatType: {
                    this.leftExpression = LiteralType.getLiteralExpression((Object)Float.valueOf(0.0f), variableExpression.getType());
                    break;
                }
                case IntegerType: {
                    this.leftExpression = LiteralType.getLiteralExpression((Object)0, variableExpression.getType());
                    break;
                }
                case StringType: {
                    this.leftExpression = LiteralType.getLiteralExpression((Object)"", variableExpression.getType());
                    break;
                }
                default: {
                    this.leftExpression = new NullLiteral();
                }
            }
        }
        return super.interpret(expressionBinding, instancesBinding);
    }
}

