/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.chain;

import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.StringType;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.ChainOperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.util.TrimString;

@Operation(type=OperationType.APPEND, dataTypes={DataType.StringType})
public class Append
extends ChainOperationExpression {
    public Append() {
        super(OperationType.APPEND);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        this.leftValueOperand = super.interpretOperand(this.leftOperand, expressionBinding, instancesBinding);
        LiteralExpression literalExpression = this.toLiteralExpression(this.leftValueOperand);
        if (literalExpression != null && !(literalExpression instanceof NullLiteral)) {
            if (literalExpression.getValue() == null) {
                return new NullLiteral();
            }
            String value = literalExpression.getValue().toString();
            value = TrimString.trim(value);
            LiteralExpression startExpression = (LiteralExpression)this.rightOperand.get(0);
            String start = startExpression.getValue() instanceof Integer ? (String)startExpression.getValue() : startExpression.getValue().toString();
            start = TrimString.trim(start);
            value = value.concat(start);
            return LiteralType.getLiteralExpression((Object)value, StringType.class);
        }
        return new NullLiteral();
    }
}

