/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.chain;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.datatype.IntegerType;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.ChainOperationExpression;
import org.dvare.expression.operation.OperationType;

@Operation(type=OperationType.GET_YEARS)
public class GetYear
extends ChainOperationExpression {
    public GetYear() {
        super(OperationType.GET_YEARS);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        this.leftValueOperand = super.interpretOperand(this.leftOperand, expressionBinding, instancesBinding);
        LiteralExpression literalExpression = this.toLiteralExpression(this.leftValueOperand);
        if (literalExpression != null && !(literalExpression instanceof NullLiteral)) {
            if (literalExpression.getValue() == null) {
                return new NullLiteral();
            }
            Object value = literalExpression.getValue();
            switch (this.toDataType(literalExpression.getType())) {
                case DateType: {
                    if (!(value instanceof LocalDate)) break;
                    LocalDate localDate = (LocalDate)value;
                    return LiteralType.getLiteralExpression((Object)localDate.getYear(), IntegerType.class);
                }
                case DateTimeType: {
                    if (!(value instanceof LocalDateTime)) break;
                    LocalDateTime localDateTime = (LocalDateTime)value;
                    return LiteralType.getLiteralExpression((Object)localDateTime.getYear(), IntegerType.class);
                }
                case SimpleDateType: {
                    if (!(value instanceof Date)) break;
                    Date date = (Date)value;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    return LiteralType.getLiteralExpression((Object)calendar.get(1), IntegerType.class);
                }
            }
        }
        return new NullLiteral();
    }
}

