/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.chain;

import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.exceptions.parser.IllegalValueException;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.ChainOperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.util.TrimString;

@Operation(type=OperationType.STARTS_WITH, dataTypes={DataType.StringType})
public class StartsWith
extends ChainOperationExpression {
    public StartsWith() {
        super(OperationType.STARTS_WITH);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        this.leftValueOperand = super.interpretOperand(this.leftOperand, expressionBinding, instancesBinding);
        LiteralExpression literalExpression = this.toLiteralExpression(this.leftValueOperand);
        if (literalExpression != null && !(literalExpression instanceof NullLiteral)) {
            if (literalExpression.getValue() == null) {
                return new NullLiteral();
            }
            String value = literalExpression.getValue().toString();
            value = TrimString.trim(value);
            LiteralExpression startExpression = (LiteralExpression)this.rightOperand.get(0);
            String start = startExpression.getValue() instanceof Integer ? (String)startExpression.getValue() : startExpression.getValue().toString();
            start = TrimString.trim(start);
            Boolean result = value.startsWith(start);
            try {
                LiteralExpression<?> returnExpression = LiteralType.getLiteralExpression((Object)result.toString(), DataType.BooleanType);
                return returnExpression;
            }
            catch (IllegalValueException illegalValueException) {
                // empty catch block
            }
        }
        return new NullLiteral();
    }
}

