/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.chain;

import java.util.Stack;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.StringType;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.ChainOperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.util.TrimString;

@Operation(type=OperationType.SUBSTRING, dataTypes={DataType.StringType})
public class Substring
extends ChainOperationExpression {
    public Substring() {
        super(OperationType.SUBSTRING);
    }

    @Override
    public Integer parse(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        pos = super.parse(tokens, pos, stack, expressionBinding, contexts);
        if (this.rightOperand.size() != 2) {
            throw new ExpressionParseException(String.format("%s must contain two parameters at %d", this.getClass().getSimpleName(), pos));
        }
        return pos;
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        this.leftValueOperand = super.interpretOperand(this.leftOperand, expressionBinding, instancesBinding);
        LiteralExpression literalExpression = this.toLiteralExpression(this.leftValueOperand);
        if (literalExpression != null && !(literalExpression instanceof NullLiteral) && this.rightOperand.size() >= 2) {
            if (literalExpression.getValue() == null) {
                return new NullLiteral();
            }
            String value = literalExpression.getValue().toString();
            value = TrimString.trim(value);
            LiteralExpression indexExpression = (LiteralExpression)this.rightOperand.get(0);
            LiteralExpression countExpression = (LiteralExpression)this.rightOperand.get(1);
            Integer index = indexExpression.getValue() instanceof Integer ? (Integer)indexExpression.getValue() : Integer.valueOf(Integer.parseInt(indexExpression.getValue().toString()));
            Integer count = countExpression.getValue() instanceof Integer ? (Integer)countExpression.getValue() : Integer.valueOf(Integer.parseInt(countExpression.getValue().toString()));
            if (value.length() < count) {
                return new NullLiteral();
            }
            Integer start = index - 1;
            Integer end = index - 1 + count;
            if (start < 0 || end > value.length()) {
                return new NullLiteral();
            }
            try {
                value = value.substring(start, end);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                value = value.substring(index, index + count);
            }
            return LiteralType.getLiteralExpression((Object)value, StringType.class);
        }
        return new NullLiteral();
    }
}

