/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.chain;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.literal.DateLiteral;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.ChainOperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.util.TrimString;

@Operation(type=OperationType.TO_DATE, dataTypes={DataType.StringType})
public class ToDate
extends ChainOperationExpression {
    public ToDate() {
        super(OperationType.TO_DATE);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        this.leftValueOperand = super.interpretOperand(this.leftOperand, expressionBinding, instancesBinding);
        LiteralExpression literalExpression = this.toLiteralExpression(this.leftValueOperand);
        if (literalExpression != null && !(literalExpression instanceof NullLiteral)) {
            if (literalExpression.getValue() == null) {
                return new NullLiteral();
            }
            if (literalExpression instanceof DateLiteral) {
                return literalExpression;
            }
            Object value = literalExpression.getValue();
            try {
                LocalDate localDate = null;
                if (value instanceof LocalDate) {
                    localDate = (LocalDate)value;
                } else if (value instanceof Date) {
                    Date date = (Date)value;
                    localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                } else {
                    String valueString = literalExpression.getValue().toString();
                    if ((valueString = TrimString.trim(valueString)).matches(LiteralType.date)) {
                        localDate = LocalDate.parse(valueString, LiteralType.dateFormat);
                    }
                }
                if (localDate != null) {
                    return LiteralType.getLiteralExpression((Object)localDate, DataType.DateType);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return new NullLiteral();
    }
}

