/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.chain;

import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.exceptions.parser.IllegalValueException;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.ChainOperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.util.TrimString;

@Operation(type=OperationType.TO_INTEGER, dataTypes={DataType.StringType})
public class ToInteger
extends ChainOperationExpression {
    public ToInteger() {
        super(OperationType.TO_INTEGER);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        this.leftValueOperand = super.interpretOperand(this.leftOperand, expressionBinding, instancesBinding);
        LiteralExpression literalExpression = this.toLiteralExpression(this.leftValueOperand);
        if (literalExpression != null && !(literalExpression instanceof NullLiteral)) {
            if (literalExpression.getValue() == null) {
                return new NullLiteral();
            }
            String value = literalExpression.getValue().toString();
            value = TrimString.trim(value);
            try {
                LiteralExpression<?> returnExpression = LiteralType.getLiteralExpression((Object)Integer.parseInt(value), DataType.IntegerType);
                return returnExpression;
            }
            catch (IllegalValueException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (NumberFormatException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return new NullLiteral();
    }
}

