/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.chain;

import java.time.LocalDate;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.datatype.StringType;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.ChainOperationExpression;
import org.dvare.expression.operation.OperationType;

@Operation(type=OperationType.TO_STRING)
public class ToString
extends ChainOperationExpression {
    public ToString() {
        super(OperationType.TO_STRING);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        this.leftValueOperand = super.interpretOperand(this.leftOperand, expressionBinding, instancesBinding);
        LiteralExpression literalExpression = this.toLiteralExpression(this.leftValueOperand);
        if (literalExpression != null && !(literalExpression instanceof NullLiteral)) {
            String valueString;
            if (literalExpression.getValue() == null) {
                return new NullLiteral();
            }
            Object value = literalExpression.getValue();
            if (value instanceof LocalDate) {
                LocalDate localDate = (LocalDate)value;
                valueString = LiteralType.dateFormat.format(localDate);
            } else {
                valueString = value.toString();
            }
            if (valueString != null) {
                return LiteralType.getLiteralExpression((Object)valueString, StringType.class);
            }
        }
        return new NullLiteral();
    }
}

