/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.chain;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.ChainOperationExpression;
import org.dvare.expression.operation.OperationType;

@Operation(type=OperationType.ADD_DAYS)
public class addDays
extends ChainOperationExpression {
    public addDays() {
        super(OperationType.ADD_DAYS);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        this.leftValueOperand = super.interpretOperand(this.leftOperand, expressionBinding, instancesBinding);
        LiteralExpression literalExpression = this.toLiteralExpression(this.leftValueOperand);
        if (literalExpression != null && !(literalExpression instanceof NullLiteral) && this.rightOperand != null && this.rightOperand.size() == 1) {
            if (literalExpression.getValue() == null) {
                return new NullLiteral();
            }
            LiteralExpression dayssExpression = (LiteralExpression)this.rightOperand.get(0);
            Object daysValue = dayssExpression.getValue();
            Object value = literalExpression.getValue();
            this.dataTypeExpression = literalExpression.getType();
            switch (this.toDataType(this.dataTypeExpression)) {
                case DateType: {
                    if (!(value instanceof LocalDate) || !(daysValue instanceof Integer)) break;
                    LocalDate localDate = (LocalDate)value;
                    Integer days = (Integer)daysValue;
                    localDate = localDate.plusDays(days.intValue());
                    return LiteralType.getLiteralExpression((Object)localDate, this.dataTypeExpression);
                }
                case DateTimeType: {
                    if (!(value instanceof LocalDateTime) || !(daysValue instanceof Integer)) break;
                    LocalDateTime localDateTime = (LocalDateTime)value;
                    Integer days = (Integer)daysValue;
                    localDateTime = localDateTime.plusDays(days.intValue());
                    return LiteralType.getLiteralExpression((Object)localDateTime, this.dataTypeExpression);
                }
                case SimpleDateType: {
                    if (!(value instanceof Date) || !(daysValue instanceof Integer)) break;
                    Date date = (Date)value;
                    Integer days = (Integer)daysValue;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    calendar.add(5, days);
                    return LiteralType.getLiteralExpression((Object)calendar.getTime(), this.dataTypeExpression);
                }
            }
        }
        return new NullLiteral();
    }
}

