/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.chain;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.ChainOperationExpression;
import org.dvare.expression.operation.OperationType;

@Operation(type=OperationType.ADD_MONTHS)
public class addMonths
extends ChainOperationExpression {
    public addMonths() {
        super(OperationType.ADD_MONTHS);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        this.leftValueOperand = super.interpretOperand(this.leftOperand, expressionBinding, instancesBinding);
        LiteralExpression literalExpression = this.toLiteralExpression(this.leftValueOperand);
        if (literalExpression != null && !(literalExpression instanceof NullLiteral) && this.rightOperand != null && this.rightOperand.size() == 1) {
            if (literalExpression.getValue() == null) {
                return new NullLiteral();
            }
            LiteralExpression monthssExpression = (LiteralExpression)this.rightOperand.get(0);
            Object monthsValue = monthssExpression.getValue();
            Object value = literalExpression.getValue();
            this.dataTypeExpression = literalExpression.getType();
            switch (this.toDataType(this.dataTypeExpression)) {
                case DateType: {
                    if (!(value instanceof LocalDate) || !(monthsValue instanceof Integer)) break;
                    LocalDate localDate = (LocalDate)value;
                    Integer months = (Integer)monthsValue;
                    localDate = localDate.plusMonths(months.intValue());
                    return LiteralType.getLiteralExpression((Object)localDate, this.dataTypeExpression);
                }
                case DateTimeType: {
                    if (!(value instanceof LocalDateTime) || !(monthsValue instanceof Integer)) break;
                    LocalDateTime localDateTime = (LocalDateTime)value;
                    Integer months = (Integer)monthsValue;
                    localDateTime = localDateTime.plusMonths(months.intValue());
                    return LiteralType.getLiteralExpression((Object)localDateTime, this.dataTypeExpression);
                }
                case SimpleDateType: {
                    if (!(value instanceof Date) || !(monthsValue instanceof Integer)) break;
                    Date date = (Date)value;
                    Integer months = (Integer)monthsValue;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    calendar.add(2, months);
                    return LiteralType.getLiteralExpression((Object)calendar.getTime(), this.dataTypeExpression);
                }
            }
        }
        return new NullLiteral();
    }
}

