/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.condition;

import java.util.Stack;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.config.ConfigurationRegistry;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.expression.Expression;
import org.dvare.expression.operation.ConditionOperationExpression;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.operation.condition.ELSE;
import org.dvare.expression.operation.condition.ENDIF;
import org.dvare.expression.operation.condition.THEN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(type=OperationType.IF)
public class IF
extends ConditionOperationExpression {
    static Logger logger = LoggerFactory.getLogger(IF.class);

    public IF() {
        super(OperationType.IF);
    }

    @Override
    public Integer parse(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        pos = this.findNextExpression(tokens, pos + 1, stack, expressionBinding, contexts);
        stack.push(this);
        return pos;
    }

    @Override
    public Integer findNextExpression(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        ConfigurationRegistry configurationRegistry = ConfigurationRegistry.INSTANCE;
        while (pos < tokens.length) {
            OperationExpression operation = configurationRegistry.getOperation(tokens[pos]);
            if (operation != null) {
                if (operation instanceof IF || operation instanceof ELSE || operation instanceof THEN || operation instanceof ENDIF) {
                    if (operation instanceof THEN) {
                        pos = operation.parse(tokens, pos, stack, expressionBinding, contexts);
                        this.thenOperand = stack.pop();
                    } else {
                        if (operation instanceof ELSE) {
                            pos = operation.parse(tokens, pos, stack, expressionBinding, contexts);
                            this.elseOperand = stack.pop();
                            return pos;
                        }
                        if (operation instanceof ENDIF) {
                            return pos;
                        }
                    }
                } else {
                    if (this.condition != null) {
                        stack.push(this.condition);
                    }
                    pos = operation.parse(tokens, pos, stack, expressionBinding, contexts);
                    this.condition = stack.pop();
                }
            }
            ++pos;
        }
        return pos;
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        Boolean result = this.toBoolean(this.condition.interpret(expressionBinding, instancesBinding));
        if (result.booleanValue()) {
            return this.thenOperand.interpret(expressionBinding, instancesBinding);
        }
        if (this.elseOperand != null) {
            return this.elseOperand.interpret(expressionBinding, instancesBinding);
        }
        return result;
    }
}

