/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.list;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.binding.model.TypeBinding;
import org.dvare.config.ConfigurationRegistry;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.expression.Expression;
import org.dvare.expression.NamedExpression;
import org.dvare.expression.datatype.BooleanType;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.literal.ListLiteral;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.operation.ListOperationExpression;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.operation.list.EndForAllEach;
import org.dvare.expression.operation.validation.LeftPriority;
import org.dvare.expression.veriable.VariableExpression;
import org.dvare.expression.veriable.VariableType;
import org.dvare.util.TypeFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(type=OperationType.FORALL)
public class ForAll
extends OperationExpression {
    private static Logger logger = LoggerFactory.getLogger(ForAll.class);
    private String refrenceValueToken;
    private String driveContexttToken;

    public ForAll() {
        super(OperationType.FORALL);
    }

    @Override
    public Integer parse(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        this.refrenceValueToken = tokens[pos - 1];
        this.driveContexttToken = tokens[++pos];
        ++pos;
        Expression valueExpression = null;
        if (stack.isEmpty()) {
            TypeBinding typeBinding;
            OperationExpression.TokenType tokenType = ForAll.findDataObject(this.refrenceValueToken, contexts);
            if (tokenType.type != null && contexts.getContext(tokenType.type) != null && TypeFinder.findType(tokenType.token, contexts.getContext(tokenType.type)) != null) {
                typeBinding = contexts.getContext(tokenType.type);
                DataType variableType = TypeFinder.findType(tokenType.token, typeBinding);
                valueExpression = VariableType.getVariableType(tokenType.token, variableType, tokenType.type);
            } else {
                typeBinding = contexts.getContext(this.refrenceValueToken);
                if (contexts.getContext(this.refrenceValueToken) != null) {
                    contexts.addContext(this.driveContexttToken, typeBinding);
                    this.leftOperand = new NamedExpression(this.refrenceValueToken);
                }
            }
        } else {
            valueExpression = stack.pop();
        }
        if (valueExpression instanceof ListOperationExpression) {
            ListOperationExpression listOperationExpression = (ListOperationExpression)valueExpression;
            Expression leftExpression = listOperationExpression.getLeftOperand();
            while (leftExpression instanceof OperationExpression) {
                leftExpression = ((OperationExpression)leftExpression).getLeftOperand();
            }
            if (leftExpression instanceof VariableExpression) {
                VariableExpression variableExpression = (VariableExpression)leftExpression;
                this.leftOperand = valueExpression;
                DataType dataType = this.toDataType(variableExpression.getType());
                OperationExpression.TokenType tokenType = ForAll.buildTokenType(this.driveContexttToken);
                if (contexts.getContext(tokenType.type) != null) {
                    TypeBinding typeBinding = contexts.getContext(tokenType.type);
                    typeBinding.addTypes(tokenType.token, (Object)dataType);
                    contexts.addContext(tokenType.type, typeBinding);
                } else {
                    TypeBinding typeBinding = new TypeBinding();
                    typeBinding.addTypes(tokenType.token, (Object)dataType);
                    contexts.addContext(tokenType.type, typeBinding);
                }
            }
        }
        pos = this.findNextExpression(tokens, pos, stack, expressionBinding, contexts);
        this.rightOperand = stack.pop();
        contexts.removeContext(this.driveContexttToken);
        if (logger.isDebugEnabled()) {
            logger.debug("OperationExpression Call Expression : {}", (Object)this.getClass().getSimpleName());
        }
        stack.push(this);
        return pos;
    }

    @Override
    public Integer findNextExpression(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        ConfigurationRegistry configurationRegistry = ConfigurationRegistry.INSTANCE;
        while (pos < tokens.length) {
            String token = tokens[pos];
            OperationExpression op = configurationRegistry.getOperation(token);
            if (op != null) {
                if (op.getClass().equals(EndForAllEach.class)) {
                    return pos;
                }
                if (!op.getClass().equals(LeftPriority.class)) {
                    pos = op.parse(tokens, pos, stack, expressionBinding, contexts);
                }
            } else {
                stack.add(this.buildExpression(token, contexts));
            }
            ++pos;
        }
        throw new ExpressionParseException("Function Closing Bracket Not Found");
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        OperationExpression valuesOperation;
        Object valuesResult;
        if (this.leftOperand instanceof NamedExpression) {
            Object object = instancesBinding.getInstance(this.refrenceValueToken);
            if (object instanceof List) {
                List instances = (List)object;
                ArrayList<Boolean> results = new ArrayList<Boolean>();
                for (Object instance : instances) {
                    instancesBinding.addInstance(this.driveContexttToken, instance);
                    Object result = this.rightOperand.interpret(expressionBinding, instancesBinding);
                    results.add(this.toBoolean(result));
                }
                instancesBinding.removeInstance(this.refrenceValueToken);
                Boolean result = results.stream().allMatch(Boolean::booleanValue);
                return LiteralType.getLiteralExpression((Object)result, BooleanType.class);
            }
        } else if (this.leftOperand instanceof ListOperationExpression && (valuesResult = (valuesOperation = (OperationExpression)this.leftOperand).interpret(expressionBinding, instancesBinding)) instanceof ListLiteral) {
            ListLiteral listLiteral = (ListLiteral)valuesResult;
            this.dataTypeExpression = listLiteral.getType();
            List values = (List)listLiteral.getValue();
            for (Object e : values) {
            }
        }
        return LiteralType.getLiteralExpression((Object)false, BooleanType.class);
    }
}

