/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.list;

import java.util.List;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.DataRow;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.Expression;
import org.dvare.expression.literal.IntegerLiteral;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.AggregationOperationExpression;
import org.dvare.expression.operation.ArithmeticOperationExpression;
import org.dvare.expression.operation.ChainOperationExpression;
import org.dvare.expression.operation.EqualityOperationExpression;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.veriable.VariableExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(type=OperationType.GET_ITEM)
public class GetItem
extends AggregationOperationExpression {
    private static Logger logger = LoggerFactory.getLogger(GetItem.class);

    public GetItem() {
        super(OperationType.GET_ITEM);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        List<Object> values = this.buildValues(this.leftOperand, expressionBinding, instancesBinding);
        if (values != null && !this.rightOperand.isEmpty()) {
            Expression expression = (Expression)this.rightOperand.get(0);
            if (expression instanceof ArithmeticOperationExpression || expression instanceof AggregationOperationExpression) {
                OperationExpression operationExpression = (OperationExpression)expression;
                Object interpret = operationExpression.interpret(expressionBinding, instancesBinding);
                if (interpret instanceof IntegerLiteral) {
                    return this.buildItem(values, (IntegerLiteral)interpret, this.dataTypeExpression);
                }
            } else if (expression instanceof EqualityOperationExpression || expression instanceof ChainOperationExpression) {
                OperationExpression operationExpression = (OperationExpression)expression;
                Expression leftExpression = operationExpression.getLeftOperand();
                while (leftExpression instanceof OperationExpression) {
                    leftExpression = ((OperationExpression)leftExpression).getLeftOperand();
                }
                if (leftExpression instanceof VariableExpression) {
                    VariableExpression variableExpression = (VariableExpression)leftExpression;
                    String name = variableExpression.getName();
                    String operandType = variableExpression.getOperandType();
                    for (Object value : values) {
                        Object interpret;
                        Boolean result;
                        DataRow dataRow;
                        Object instance = instancesBinding.getInstance(operandType);
                        if (instance == null || !(instance instanceof DataRow)) {
                            dataRow = new DataRow();
                            dataRow.addData(name, value);
                            instancesBinding.addInstance(operandType, dataRow);
                        } else {
                            dataRow = (DataRow)instance;
                            dataRow.addData(name, value);
                            instancesBinding.addInstance(operandType, dataRow);
                        }
                        if (!(result = this.toBoolean(interpret = operationExpression.interpret(expressionBinding, instancesBinding))).booleanValue()) continue;
                        return LiteralType.getLiteralExpression(value, this.dataTypeExpression);
                    }
                }
            } else if (expression instanceof IntegerLiteral) {
                return this.buildItem(values, (IntegerLiteral)expression, this.dataTypeExpression);
            }
        }
        return new NullLiteral();
    }

    private LiteralExpression buildItem(List<Object> values, IntegerLiteral integerLiteral, Class dataTypeExpress) throws InterpretException {
        Integer index = (Integer)integerLiteral.getValue();
        if (index != null && values != null) {
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index - 1);
            if (index < values.size()) {
                Object value = values.get(index);
                return LiteralType.getLiteralExpression(value, dataTypeExpress);
            }
        }
        return new NullLiteral();
    }
}

