/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.list;

import java.util.List;
import java.util.Stack;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.operation.validation.Match;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(type=OperationType.INSIDE_COMB)
public class InsideCombination
extends Match {
    private static Logger logger = LoggerFactory.getLogger(InsideCombination.class);

    public InsideCombination() {
        super(OperationType.INSIDE_COMB);
    }

    @Override
    public Integer parse(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contextss) throws ExpressionParseException {
        pos = this.findNextExpression(tokens, pos + 1, stack, expressionBinding, contextss);
        this.computeParam(this.leftOperand);
        stack.push(this);
        return pos;
    }

    private void computeParam(List<Expression> expressions) throws ExpressionParseException {
        if (expressions == null || expressions.size() != 2) {
            String error = "InsideComb Operation must have two parameter";
            logger.error(error);
            throw new ExpressionParseException(error);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("OperationExpression Call Expression : {}", (Object)this.getClass().getSimpleName());
        }
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        List expressions = this.leftOperand;
        Expression valueParam = (Expression)expressions.get(0);
        List values = this.buildValues(expressionBinding, instancesBinding, valueParam);
        DataType dataType = this.toDataType(this.dataTypeExpression);
        Expression paramsExpression = (Expression)expressions.get(1);
        List matchParams = this.buildMatchParams(expressionBinding, instancesBinding, paramsExpression);
        return this.match(dataType, values, matchParams, true, false);
    }
}

