/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.list;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.DataType;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.literal.ListLiteral;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.ListOperationExpression;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.operation.list.PairOperation;
import org.dvare.expression.operation.list.ValuesOperation;
import org.dvare.util.DataTypeMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(type=OperationType.KEYS)
public class KeysOperation
extends ValuesOperation {
    static Logger logger = LoggerFactory.getLogger(KeysOperation.class);

    public KeysOperation() {
        super(OperationType.KEYS);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        List<Object> pairKeys;
        if ((this.leftOperand instanceof PairOperation || this.leftOperand instanceof ListOperationExpression) && (pairKeys = this.pairKeys(this.leftOperand, expressionBinding, instancesBinding)) != null) {
            return new ListLiteral(pairKeys, (Class<? extends DataTypeExpression>)this.dataTypeExpression);
        }
        return new NullLiteral();
    }

    protected List<Object> pairKeys(Expression expression, ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        OperationExpression pairOperation;
        Object pairResultList;
        if ((expression instanceof PairOperation || this.leftOperand instanceof ListOperationExpression) && (pairResultList = (pairOperation = (OperationExpression)expression).interpret(expressionBinding, instancesBinding)) instanceof ListLiteral) {
            ListLiteral listLiteral = (ListLiteral)pairResultList;
            List pairList = (List)listLiteral.getValue();
            ArrayList<Object> pairKeys = new ArrayList<Object>();
            for (Object pairObject : pairList) {
                if (!(pairObject instanceof Pair)) continue;
                Pair pair = (Pair)pairObject;
                if (this.dataTypeExpression == null) {
                    DataType dataType = DataTypeMapping.getTypeMapping(pair.getKey().getClass());
                    this.dataTypeExpression = DataTypeMapping.getDataTypeClass(dataType);
                }
                pairKeys.add(pair.getKey());
            }
            return pairKeys;
        }
        return null;
    }
}

