/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.list;

import java.util.ArrayList;
import java.util.List;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.Expression;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.AggregationOperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.veriable.VariableExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(type=OperationType.LAST)
public class Last
extends AggregationOperationExpression {
    static Logger logger = LoggerFactory.getLogger(Last.class);

    public Last() {
        super(OperationType.LAST);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        Expression right = this.leftOperand;
        if (right instanceof VariableExpression) {
            ArrayList<Object> dataSet;
            VariableExpression variableExpression = (VariableExpression)right;
            Object instance = instancesBinding.getInstance(variableExpression.getOperandType());
            if (instance instanceof List) {
                dataSet = (ArrayList<Object>)instance;
            } else {
                dataSet = new ArrayList<Object>();
                dataSet.add(instance);
            }
            ArrayList values = new ArrayList();
            for (Object e : dataSet) {
                Object value = this.getValue(e, variableExpression.getName());
                LiteralExpression<?> literalExpression = LiteralType.getLiteralExpression(value, variableExpression.getType());
                values.add(literalExpression.getValue());
            }
            if (!values.isEmpty()) {
                return LiteralType.getLiteralExpression(values.get(values.size() - 1), variableExpression.getType());
            }
        } else {
            List<Object> values = this.buildValues(this.leftOperand, expressionBinding, instancesBinding);
            if (values != null && !values.isEmpty()) {
                return LiteralType.getLiteralExpression(values.get(values.size() - 1), this.dataTypeExpression);
            }
        }
        return new NullLiteral();
    }
}

