/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.list;

import java.util.ArrayList;
import java.util.List;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.IntegerType;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.operation.AggregationOperationExpression;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.veriable.VariableExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(type=OperationType.LENGTH)
public class Length
extends AggregationOperationExpression {
    static Logger logger = LoggerFactory.getLogger(Length.class);

    public Length() {
        super(OperationType.LENGTH);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        Expression right = this.leftOperand;
        if (right instanceof OperationExpression) {
            List<Object> values = this.buildValues(this.leftOperand, expressionBinding, instancesBinding);
            if (values != null) {
                return LiteralType.getLiteralExpression((Object)values.size(), IntegerType.class);
            }
        } else if (right instanceof VariableExpression) {
            ArrayList<Object> dataSet;
            VariableExpression variableExpression = (VariableExpression)right;
            Object instance = instancesBinding.getInstance(variableExpression.getOperandType());
            if (instance instanceof List) {
                dataSet = (ArrayList<Object>)instance;
            } else {
                dataSet = new ArrayList<Object>();
                dataSet.add(instance);
            }
            ArrayList values = new ArrayList();
            for (Object e : dataSet) {
                Object value = this.getValue(e, variableExpression.getName());
                LiteralExpression<?> literalExpression = LiteralType.getLiteralExpression(value, variableExpression.getType());
                values.add(literalExpression.getValue());
            }
            return LiteralType.getLiteralExpression((Object)values.size(), IntegerType.class);
        }
        return LiteralType.getLiteralExpression((Object)0, IntegerType.class);
    }
}

