/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.list;

import java.util.ArrayList;
import java.util.List;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.BooleanType;
import org.dvare.expression.literal.ListLiteral;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.LiteralType;
import org.dvare.expression.operation.AggregationOperationExpression;
import org.dvare.expression.operation.ListOperationExpression;
import org.dvare.expression.operation.OperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.operation.list.PairOperation;
import org.dvare.expression.operation.utility.GetExpOperation;
import org.dvare.expression.veriable.VariableExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(type=OperationType.NOT_EMPTY)
public class NotEmpty
extends AggregationOperationExpression {
    static Logger logger = LoggerFactory.getLogger(NotEmpty.class);

    public NotEmpty() {
        super(OperationType.NOT_EMPTY);
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        Expression right = this.leftOperand;
        if (right instanceof PairOperation || right instanceof ListOperationExpression || right instanceof GetExpOperation) {
            OperationExpression valuesOperation = (OperationExpression)right;
            Object valuesResult = valuesOperation.interpret(expressionBinding, instancesBinding);
            if (valuesResult instanceof ListLiteral) {
                ListLiteral listLiteral = (ListLiteral)valuesResult;
                return LiteralType.getLiteralExpression((Object)(listLiteral.getSize() != 0 ? 1 : 0), BooleanType.class);
            }
        } else if (right instanceof VariableExpression) {
            ArrayList<Object> dataSet;
            VariableExpression variableExpression = (VariableExpression)right;
            Object instance = instancesBinding.getInstance(variableExpression.getOperandType());
            if (instance instanceof List) {
                dataSet = (ArrayList<Object>)instance;
            } else {
                dataSet = new ArrayList<Object>();
                dataSet.add(instance);
            }
            ArrayList values = new ArrayList();
            for (Object e : dataSet) {
                Object value = this.getValue(e, variableExpression.getName());
                LiteralExpression<?> literalExpression = LiteralType.getLiteralExpression(value, variableExpression.getType());
                values.add(literalExpression.getValue());
            }
            return LiteralType.getLiteralExpression((Object)(values.size() != 0 ? 1 : 0), BooleanType.class);
        }
        return LiteralType.getLiteralExpression((Object)false, BooleanType.class);
    }
}

