/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.expression.operation.list;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.tuple.Pair;
import org.dvare.annotations.Operation;
import org.dvare.binding.data.InstancesBinding;
import org.dvare.binding.expression.ExpressionBinding;
import org.dvare.binding.model.ContextsBinding;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.exceptions.parser.ExpressionParseException;
import org.dvare.expression.Expression;
import org.dvare.expression.datatype.DataTypeExpression;
import org.dvare.expression.datatype.NullType;
import org.dvare.expression.literal.ListLiteral;
import org.dvare.expression.literal.LiteralExpression;
import org.dvare.expression.literal.NullLiteral;
import org.dvare.expression.operation.AggregationOperationExpression;
import org.dvare.expression.operation.ChainOperationExpression;
import org.dvare.expression.operation.OperationType;
import org.dvare.expression.veriable.VariableExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(type=OperationType.PAIR)
public class PairOperation
extends AggregationOperationExpression {
    private static Logger logger = LoggerFactory.getLogger(PairOperation.class);

    public PairOperation() {
        super(OperationType.PAIR);
    }

    public PairOperation(OperationType operationType) {
        super(operationType);
    }

    @Override
    public Integer parse(String[] tokens, int pos, Stack<Expression> stack, ExpressionBinding expressionBinding, ContextsBinding contexts) throws ExpressionParseException {
        pos = this.findNextExpression(tokens, pos + 1, stack, expressionBinding, contexts);
        if (this.rightOperand.size() != 2) {
            throw new ExpressionParseException(" Pair Operation must contains 2 params ");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Operation Expression Call Expression : {}", (Object)this.getClass().getSimpleName());
        }
        stack.push(this);
        return pos;
    }

    @Override
    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder();
        toStringBuilder.append(this.operationType.getSymbols().get(0));
        toStringBuilder.append("( ");
        if (this.rightOperand != null) {
            toStringBuilder.append(this.rightOperand.toString());
            toStringBuilder.append(" )");
        }
        return toStringBuilder.toString();
    }

    @Override
    public Object interpret(ExpressionBinding expressionBinding, InstancesBinding instancesBinding) throws InterpretException {
        if (this.rightOperand.size() == 2) {
            Expression left = (Expression)this.rightOperand.get(0);
            Expression right = (Expression)this.rightOperand.get(1);
            VariableExpression leftVariableExpression = null;
            ChainOperationExpression leftOperationExpression = null;
            if (left instanceof VariableExpression) {
                leftVariableExpression = (VariableExpression)left;
            } else if (left instanceof ChainOperationExpression) {
                leftOperationExpression = (ChainOperationExpression)left;
                Expression expression = leftOperationExpression.getLeftOperand();
                while (expression instanceof ChainOperationExpression) {
                    expression = ((ChainOperationExpression)expression).getLeftOperand();
                }
                if (expression instanceof VariableExpression) {
                    leftVariableExpression = (VariableExpression)expression;
                }
            }
            VariableExpression rightVariableExpression = null;
            ChainOperationExpression rightOperationExpression = null;
            if (right instanceof VariableExpression) {
                rightVariableExpression = (VariableExpression)right;
                this.dataTypeExpression = rightVariableExpression.getType();
            } else if (right instanceof ChainOperationExpression) {
                rightOperationExpression = (ChainOperationExpression)right;
                Expression expression = rightOperationExpression.getLeftOperand();
                while (expression instanceof ChainOperationExpression) {
                    expression = ((ChainOperationExpression)expression).getLeftOperand();
                }
                if (expression instanceof VariableExpression) {
                    rightVariableExpression = (VariableExpression)expression;
                    this.dataTypeExpression = rightVariableExpression.getType();
                }
            }
            if (leftVariableExpression != null && rightVariableExpression != null) {
                ArrayList<Object> rightDataSet;
                ArrayList<Object> leftDataSet;
                Object leftInstance = instancesBinding.getInstance(leftVariableExpression.getOperandType());
                if (leftInstance instanceof List) {
                    leftDataSet = (ArrayList<Object>)leftInstance;
                } else {
                    leftDataSet = new ArrayList<Object>();
                    leftDataSet.add(leftInstance);
                }
                Object rightInstance = instancesBinding.getInstance(rightVariableExpression.getOperandType());
                if (rightInstance instanceof List) {
                    rightDataSet = (ArrayList<Object>)rightInstance;
                } else {
                    rightDataSet = new ArrayList<Object>();
                    rightDataSet.add(rightInstance);
                }
                ArrayList<Pair> pairs = new ArrayList<Pair>();
                Iterator leftIterator = leftDataSet.iterator();
                Iterator rightIterator = rightDataSet.iterator();
                while (leftIterator.hasNext() && rightIterator.hasNext()) {
                    Object rightValue;
                    Object leftValue;
                    Object templeftInstance = leftIterator.next();
                    Object temprightInstance = rightIterator.next();
                    if (leftOperationExpression != null) {
                        instancesBinding.addInstance(leftVariableExpression.getName(), templeftInstance);
                        LiteralExpression literalExpression = (LiteralExpression)leftOperationExpression.interpret(expressionBinding, instancesBinding);
                        leftValue = literalExpression.getValue();
                    } else {
                        leftValue = this.getValue(templeftInstance, leftVariableExpression.getName());
                    }
                    if (rightOperationExpression != null) {
                        instancesBinding.addInstance(rightVariableExpression.getName(), temprightInstance);
                        LiteralExpression literalExpression = (LiteralExpression)rightOperationExpression.interpret(expressionBinding, instancesBinding);
                        rightValue = literalExpression.getValue();
                        if (literalExpression.getType() != null && !literalExpression.getType().equals(NullType.class)) {
                            this.dataTypeExpression = literalExpression.getType();
                        }
                    } else {
                        rightValue = this.getValue(temprightInstance, rightVariableExpression.getName());
                    }
                    pairs.add(Pair.of((Object)leftValue, (Object)rightValue));
                }
                instancesBinding.addInstance(leftVariableExpression.getOperandType(), leftInstance);
                instancesBinding.addInstance(rightVariableExpression.getOperandType(), rightDataSet);
                return new ListLiteral(pairs, (Class<? extends DataTypeExpression>)this.dataTypeExpression);
            }
        }
        return new NullLiteral();
    }
}

